/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldCodecs;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import io.datarouter.bytes.binarydto.internal.BinaryDtoReflectionTool;
import java.lang.reflect.Field;

public class BinaryDtoFieldSchema<F> {
    public final Field field;
    private final boolean isNullable;
    private final BinaryDtoBaseFieldCodec<F> codec;

    public BinaryDtoFieldSchema(Field field) {
        this.field = field;
        BinaryDtoFieldMetadataParser fieldMetadataParser = new BinaryDtoFieldMetadataParser(field);
        this.isNullable = fieldMetadataParser.isNullable();
        this.codec = BinaryDtoFieldCodecs.getCodecForField(field);
    }

    public byte[] encodeField(Object dto) {
        F fieldValue = this.getFieldValue(dto);
        if (!this.isNullable && fieldValue == null) {
            String message = String.format("field=%s of class=%s can't contain nulls", this.field.getName(), dto.getClass().getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        return this.encodeFieldValue(fieldValue);
    }

    private byte[] encodeFieldValue(F fieldValue) {
        if (this.isNullable) {
            if (fieldValue == null) {
                return BinaryDtoNullFieldTool.NULL_INDICATOR_TRUE_ARRAY;
            }
            return ByteTool.concat(BinaryDtoNullFieldTool.NULL_INDICATOR_FALSE_ARRAY, this.codec.encode(fieldValue));
        }
        return this.codec.encode(fieldValue);
    }

    public int decodeField(Object object, byte[] bytes, int offset) {
        int cursor = offset;
        Object fieldValue = null;
        if (this.isNullable) {
            boolean isNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
            ++cursor;
            if (!isNull) {
                if (this.codec.isFixedLength()) {
                    fieldValue = this.codec.decode(bytes, cursor);
                    cursor += this.codec.fixedLength();
                } else {
                    LengthAndValue<F> lengthAndValue = this.codec.decodeWithLength(bytes, cursor);
                    cursor += lengthAndValue.length;
                    fieldValue = lengthAndValue.value;
                }
            }
        } else if (this.codec.isFixedLength()) {
            fieldValue = this.codec.decode(bytes, cursor);
            cursor += this.codec.fixedLength();
        } else {
            LengthAndValue<F> lengthAndValue = this.codec.decodeWithLength(bytes, cursor);
            cursor += lengthAndValue.length;
            fieldValue = lengthAndValue.value;
        }
        BinaryDtoReflectionTool.setUnchecked(this.field, object, fieldValue);
        return cursor - offset;
    }

    public int compareFieldValuesAsIfEncoded(Object left, Object right) {
        F leftValue = this.getFieldValue(left);
        F rightValue = this.getFieldValue(right);
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return -1;
        }
        if (rightValue == null) {
            return 1;
        }
        return this.codec.compareAsIfEncoded(leftValue, rightValue);
    }

    private F getFieldValue(Object dto) {
        return (F)BinaryDtoReflectionTool.getUnchecked(this.field, dto);
    }
}

