/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.binarydto.dto.BinaryDto;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BinaryDtoAllocator {
    private static final UnsafeAllocator ALLOCATOR = new UnsafeAllocator();

    public static <T extends BinaryDto> T allocate(Class<T> cls) {
        return (T)((BinaryDto)ALLOCATOR.allocate(cls));
    }

    private static class UnsafeAllocator {
        private final Object unsafe;
        private final Method allocateInstance;

        public UnsafeAllocator() {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                this.unsafe = theUnsafeField.get(null);
                this.allocateInstance = unsafeClass.getMethod("allocateInstance", Class.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T allocate(Class<T> cls) {
            try {
                return (T)this.allocateInstance.invoke(this.unsafe, cls);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

