/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec.iostream;

import io.datarouter.bytes.OutputStreamTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.codec.BinaryDtoCodec;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import java.io.OutputStream;

public class BinaryDtoOutputStreamWriter<T extends BinaryDto>
implements AutoCloseable {
    private final BinaryDtoCodec<T> codec;
    private final OutputStream outputStream;

    public BinaryDtoOutputStreamWriter(Class<T> dtoClass, OutputStream outputStream) {
        this.codec = BinaryDtoCodec.of(dtoClass);
        this.outputStream = outputStream;
    }

    public int write(T dto) {
        byte[] dataBytes = this.codec.encode(dto);
        byte[] lengthBytes = VarIntTool.encode(dataBytes.length);
        OutputStreamTool.write(this.outputStream, lengthBytes);
        OutputStreamTool.write(this.outputStream, dataBytes);
        return lengthBytes.length + dataBytes.length;
    }

    @Override
    public void close() {
        OutputStreamTool.close(this.outputStream);
    }
}

