/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec.bytearray;

import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.codec.BinaryDtoCodec;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.scanner.Scanner;
import java.util.List;

public class MultiBinaryDtoEncoder<T extends BinaryDto> {
    private final BinaryDtoCodec<T> codec;

    public MultiBinaryDtoEncoder(Class<T> dtoClass) {
        this.codec = BinaryDtoCodec.of(dtoClass);
    }

    public Scanner<byte[]> encode(List<T> dtos) {
        return this.encode(Scanner.of(dtos));
    }

    public Scanner<byte[]> encode(Scanner<T> dtos) {
        return dtos.concat(dto -> {
            byte[] dataBytes = this.codec.encode((BinaryDto)dto);
            byte[] lengthBytes = VarIntTool.encode(dataBytes.length);
            return Scanner.of((Object[])new byte[][]{lengthBytes, dataBytes});
        });
    }
}

