/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec.bytearray;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.codec.BinaryDtoCodec;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;

public class BinaryDtoByteArrayScanner<T extends BinaryDto>
extends BaseScanner<T> {
    private final BinaryDtoCodec<T> codec;
    private final byte[] bytes;
    private int cursor;

    public BinaryDtoByteArrayScanner(Class<T> dtoClass, byte[] bytes) {
        this.codec = BinaryDtoCodec.of(dtoClass);
        this.bytes = bytes;
        this.cursor = 0;
    }

    public static <T extends BinaryDto> Scanner<T> of(Class<T> dtoClass, byte[] bytes) {
        return new BinaryDtoByteArrayScanner<T>(dtoClass, bytes);
    }

    public boolean advance() {
        if (this.cursor == this.bytes.length) {
            return false;
        }
        int length = VarIntTool.decodeInt(this.bytes, this.cursor);
        this.cursor += VarIntTool.length(length);
        LengthAndValue<T> lengthAndValue = this.codec.decodeWithLength(this.bytes, this.cursor);
        this.current = (BinaryDto)lengthAndValue.value;
        if (length != lengthAndValue.length) {
            String message = String.format("Disagreeing lengths: expected=%s, found=%s", length, lengthAndValue.length);
            throw new IllegalStateException(message);
        }
        this.cursor += length;
        return true;
    }
}

