/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class LongArray
implements List<Long>,
RandomAccess {
    private static final int DEFAULT_INITIAL_CAPACITY = 2;
    private static final long NULL = Long.MIN_VALUE;
    private long[] array;
    private int size;

    public LongArray() {
        this(2);
    }

    public LongArray(int initialCapacity) {
        this.array = new long[initialCapacity];
        this.size = 0;
    }

    public LongArray(long[] toWrap) {
        this.array = toWrap;
        this.size = this.array.length;
    }

    public LongArray(Collection<Long> elements) {
        this(elements == null ? 0 : elements.size());
        this.addAll(0, (Collection<? extends Long>)elements);
    }

    private void expandAndShiftIfNecessary(int insertIndex, int delta) {
        int neededSize = this.size + delta;
        if (neededSize > this.array.length) {
            int newSize = Integer.highestOneBit(neededSize) << 1;
            long[] newArray = new long[newSize];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
        System.arraycopy(this.array, insertIndex, this.array, insertIndex + delta, this.size - insertIndex);
    }

    protected void shrinkIfNecessary() {
        if (this.size < this.array.length / 4) {
            int newSize = Integer.highestOneBit(this.size) << 2;
            long[] newArray = new long[newSize];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    @Override
    public void add(int index, Long value) {
        this.expandAndShiftIfNecessary(index, 1);
        this.array[index] = value == null ? Long.MIN_VALUE : value;
        ++this.size;
    }

    @Override
    public void add(int index, long value) {
        this.expandAndShiftIfNecessary(index, 1);
        this.array[index] = value;
        ++this.size;
    }

    @Override
    public boolean add(Long value) {
        this.add(this.size, value);
        return true;
    }

    @Override
    public boolean add(long value) {
        this.add(this.size, value);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> values) {
        return this.addAll(this.size, values);
    }

    @Override
    public boolean addAll(int firstIndex, Collection<? extends Long> values) {
        int delta;
        int n = delta = values == null ? 0 : values.size();
        if (delta == 0) {
            return false;
        }
        this.expandAndShiftIfNecessary(firstIndex, delta);
        int nextIndex = firstIndex;
        for (Long l : values) {
            this.array[nextIndex] = l == null ? Long.MIN_VALUE : l;
            ++nextIndex;
        }
        this.size += delta;
        return true;
    }

    @Override
    public void clear() {
        this.array = new long[1];
        this.size = 0;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj != null && !(obj instanceof Long)) {
            return false;
        }
        long value = obj == null ? Long.MIN_VALUE : (Long)obj;
        int i = 0;
        while (i < this.size) {
            if (this.array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("no nulls");
        }
        if (objects.size() == 0) {
            return true;
        }
        for (Object obj : objects) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Long get(int index) {
        if (index > this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.array[index] == Long.MIN_VALUE ? null : Long.valueOf(this.array[index]);
    }

    public long getPrimitive(int index) {
        if (index > this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.array[index];
    }

    @Override
    public int indexOf(Object obj) {
        if (obj != null && !(obj instanceof Long)) {
            return -1;
        }
        long value = obj == null ? Long.MIN_VALUE : (Long)obj;
        int i = 0;
        while (i < this.size) {
            if (this.array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return new LongArrayIterator(this);
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj != null && !(obj instanceof Long)) {
            return -1;
        }
        long value = obj == null ? Long.MIN_VALUE : (Long)obj;
        int i = this.size - 1;
        while (i >= 0) {
            if (this.array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public ListIterator<Long> listIterator() {
        return new LongArrayIterator(this);
    }

    @Override
    public ListIterator<Long> listIterator(int startIndex) {
        return new LongArrayIterator(this, startIndex);
    }

    @Override
    public Long remove(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("out of range");
        }
        long value = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        this.shrinkIfNecessary();
        return value;
    }

    @Override
    public boolean remove(Object obj) {
        if (obj != null && !(obj instanceof Long)) {
            return false;
        }
        long value = obj == null ? Long.MIN_VALUE : (Long)obj;
        int i = 0;
        while (i < this.size) {
            if (this.array[i] == value) {
                this.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean modified = false;
        for (Object obj : objects) {
            if (!this.remove(obj)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        boolean modified = false;
        int i = 0;
        while (i < this.size) {
            if (!objects.contains(this.array[i] == Long.MIN_VALUE ? null : Long.valueOf(this.array[i]))) {
                this.remove(i);
                --i;
                modified = true;
            }
            ++i;
        }
        return modified;
    }

    @Override
    public Long set(int index, Long value) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException(String.valueOf(index) + " " + this.size);
        }
        this.array[index] = value == null ? Long.MIN_VALUE : value;
        return value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<Long> subList(int fromIndex, int toIndex) {
        int newSize = toIndex - fromIndex;
        LongArray result = new LongArray(newSize);
        System.arraycopy(this.array, fromIndex, result.array, 0, newSize);
        return result;
    }

    @Override
    public Object[] toArray() {
        Long[] wrapperArray = new Long[this.size];
        return this.toArray(wrapperArray);
    }

    @Override
    public <T> T[] toArray(T[] wrapperArray) {
        int i = 0;
        while (i < this.size) {
            wrapperArray[i] = this.array[i] == Long.MIN_VALUE ? null : Long.valueOf(this.array[i]);
            ++i;
        }
        return wrapperArray;
    }

    public String toString() {
        return String.format("LongArray [array=%s, size=%d]", Arrays.toString(this.array), this.size);
    }

    public long[] getPrimitiveArray() {
        if (this.size == this.array.length) {
            return this.array;
        }
        long[] copy = new long[this.size];
        System.arraycopy(this.array, 0, copy, 0, this.size);
        return copy;
    }

    public LongArray trimmedCopy() {
        return new LongArray(Arrays.copyOf(this.array, this.size));
    }

    public LongArray sortInPlace() {
        Arrays.sort(this.array, 0, this.size);
        return this;
    }

    public LongArray copyDedupeConsecutive() {
        if (this.size == 0) {
            return new LongArray(0);
        }
        int newSize = 1;
        int i = 1;
        while (i < this.size) {
            if (this.array[i] != this.array[i - 1]) {
                ++newSize;
            }
            ++i;
        }
        long[] newArray = new long[newSize];
        newArray[0] = this.array[0];
        int nextNewIndex = 1;
        int i2 = 1;
        while (i2 < this.size) {
            if (this.array[i2] != this.array[i2 - 1]) {
                newArray[nextNewIndex] = this.array[i2];
                ++nextNewIndex;
            }
            ++i2;
        }
        return new LongArray(newArray);
    }

    public static class LongArrayIterator
    implements ListIterator<Long> {
        private LongArray wrapper;
        private int lastIndex;

        public LongArrayIterator(LongArray wrapper) {
            this.wrapper = wrapper;
            this.lastIndex = -1;
        }

        public LongArrayIterator(LongArray wrapper, int startIndex) {
            this(wrapper);
            this.lastIndex = startIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.lastIndex + 1 < this.wrapper.size;
        }

        @Override
        public Long next() {
            ++this.lastIndex;
            return this.wrapper.get(this.lastIndex);
        }

        @Override
        public void remove() {
            this.wrapper.remove(this.lastIndex + 1);
        }

        @Override
        public void add(Long value) {
            this.wrapper.set(this.lastIndex + 1, value);
        }

        @Override
        public boolean hasPrevious() {
            return this.lastIndex > -1;
        }

        @Override
        public int nextIndex() {
            return this.lastIndex + 1;
        }

        @Override
        public Long previous() {
            --this.lastIndex;
            return this.wrapper.get(this.lastIndex + 1);
        }

        @Override
        public int previousIndex() {
            return this.lastIndex;
        }

        @Override
        public void set(Long value) {
            this.wrapper.set(this.lastIndex + 1, value);
        }
    }
}

