/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.web;

import io.datarouter.aws.memcached.client.MemcachedClientMode;
import io.datarouter.aws.memcached.client.options.AwsMemcachedOptions;
import io.datarouter.client.memcached.web.MemcachedWebInspector;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AwsMemcachedWebInspector
extends MemcachedWebInspector {
    @Inject
    private AwsMemcachedOptions options;

    protected Pair<Integer, ContainerTag> getDetails(ClientId clientId) {
        MemcachedClientMode mode = this.options.getClientMode(clientId.getName());
        Pair nodeCountByNodeTag = new Pair();
        if (mode == MemcachedClientMode.DYNAMIC) {
            List nodeEndpointDtos = this.getClient(clientId).getAllNodeEndPoints().stream().map(nodeEndPoint -> new AwsMemcachedNodeEndpointDto(nodeEndPoint.getHostName(), nodeEndPoint.getIpAddress(), nodeEndPoint.getPort())).collect(Collectors.toList());
            ContainerTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("HostName", dto -> dto.hostName).withColumn("IpAddress", dto -> dto.ipAddress).withColumn("Port", dto -> dto.port).build(nodeEndpointDtos);
            ContainerTag divTable = (ContainerTag)((ContainerTag)TagCreator.div((DomContent[])new DomContent[]{table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
            nodeCountByNodeTag.setLeft((Object)nodeEndpointDtos.size());
            nodeCountByNodeTag.setRight((Object)divTable);
        } else {
            List<ContainerTag> socketAddresses = this.getClient(clientId).getAvailableServers().stream().map(Object::toString).map(TagCreator::li).collect(Collectors.toList());
            ContainerTag div = TagCreator.div((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])((DomContent[])socketAddresses.toArray(new ContainerTag[0])))});
            nodeCountByNodeTag.setLeft((Object)socketAddresses.size());
            nodeCountByNodeTag.setRight((Object)div);
        }
        return nodeCountByNodeTag;
    }

    private static class AwsMemcachedNodeEndpointDto {
        private final String hostName;
        private final String ipAddress;
        private final int port;

        public AwsMemcachedNodeEndpointDto(String hostName, String ipAddress, int port) {
            this.hostName = hostName;
            this.ipAddress = ipAddress;
            this.port = port;
        }
    }
}

