/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.aws.memcached.client.AwsMemcachedOptions;
import io.datarouter.aws.memcached.client.MemcachedClientMode;
import io.datarouter.client.memcached.client.MemcachedClientOptionsBuilder;
import io.datarouter.storage.client.ClientId;
import java.util.Properties;

public class AwsMemcachedClientOptionsBuilder
extends MemcachedClientOptionsBuilder {
    public AwsMemcachedClientOptionsBuilder(ClientId clientId) {
        super(clientId, "awsMemcached");
    }

    public AwsMemcachedClientOptionsBuilder withClientMode(MemcachedClientMode clientMode) {
        String optionKeySuffix = AwsMemcachedOptions.makeAwsMemcachedKey("clientMode");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clientMode.getPersistentString());
        return this;
    }

    public AwsMemcachedClientOptionsBuilder withClusterEndpoint(String clusterEndpoint) {
        String optionKeySuffix = AwsMemcachedOptions.makeAwsMemcachedKey("clusterEndpoint");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clusterEndpoint);
        return this;
    }

    public Properties build() {
        return this.properties;
    }
}

