/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.client.memcached.client.MemcachedOptions;
import io.datarouter.storage.client.ClientOptions;
import java.net.InetSocketAddress;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.ClientMode;

@Singleton
public class AwsMemcachedOptions
extends MemcachedOptions {
    public static final String PROP_clientMode = "clientMode";
    public static final String PROP_clusterEndpoint = "clusterEndpoint";
    @Inject
    private ClientOptions clientOptions;

    public ClientMode getClientMode(String clientName) {
        return this.clientOptions.optString(clientName, AwsMemcachedOptions.makeAwsMemcachedKey(PROP_clientMode)).filter("dynamic"::equals).map($ -> ClientMode.Dynamic).orElse(ClientMode.Static);
    }

    public Optional<InetSocketAddress> getClusterEndpoint(String clientName) {
        return this.clientOptions.optInetSocketAddress(clientName, AwsMemcachedOptions.makeAwsMemcachedKey(PROP_clusterEndpoint));
    }

    public static String makeAwsMemcachedKey(String propertyKey) {
        return "awsMemcached." + propertyKey;
    }
}

