/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.aws.memcached.client.AwsMemcachedOptions;
import io.datarouter.client.memcached.client.MemcachedClientOptionsBuilder;
import io.datarouter.storage.client.ClientId;
import java.util.Properties;
import net.spy.memcached.ClientMode;

public class AwsMemcachedClientOptionsBuilder
extends MemcachedClientOptionsBuilder {
    public AwsMemcachedClientOptionsBuilder(ClientId clientId) {
        super(clientId, "awsMemcached");
    }

    public AwsMemcachedClientOptionsBuilder withClientMode(ClientMode clientMode) {
        String optionKeySuffix = AwsMemcachedOptions.makeAwsMemcachedKey("clientMode");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clientMode.name().toLowerCase());
        return this;
    }

    public AwsMemcachedClientOptionsBuilder withClusterEndpoint(String clusterEndpoint) {
        String optionKeySuffix = AwsMemcachedOptions.makeAwsMemcachedKey("clusterEndpoint");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clusterEndpoint);
        return this;
    }

    public Properties build() {
        return this.properties;
    }
}

