/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.aws.memcached.client.AwsMemcachedOptions;
import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.storage.client.ClientId;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.ClientMode;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.KetamaConnectionFactory;

@Singleton
public class AwsMemcachedClientManager
extends MemcachedClientManager {
    @Inject
    private AwsMemcachedOptions options;

    protected SpyMemcachedClient buildSpyClient(ClientId clientId) {
        ClientMode clientMode = this.options.getClientMode(clientId.getName());
        KetamaConnectionFactory ketamaConnectionFactory = new KetamaConnectionFactory(clientMode, 16384, 16384, DefaultConnectionFactory.DEFAULT_OP_QUEUE_MAX_BLOCK_TIME){

            public long getOperationTimeout() {
                return 200L;
            }
        };
        List addresses = clientMode == ClientMode.Dynamic ? this.options.getClusterEndpoint(clientId.getName()).map(List::of).get() : this.options.getServers(clientId.getName());
        try {
            return new SpyMemcachedClient((ConnectionFactory)ketamaConnectionFactory, addresses);
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("failed to build memcached client for " + addresses, e);
        }
    }
}

