/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.web;

import io.datarouter.aws.memcached.client.MemcachedClientMode;
import io.datarouter.aws.memcached.client.options.AwsMemcachedOptions;
import io.datarouter.client.memcached.web.MemcachedWebInspector;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class AwsMemcachedWebInspector
extends MemcachedWebInspector {
    @Inject
    private AwsMemcachedOptions options;

    protected MemcachedWebInspector.MemcachedDetail getDetails(ClientId clientId) {
        MemcachedClientMode mode = this.options.getClientMode(clientId.getName());
        if (mode == MemcachedClientMode.DYNAMIC) {
            List nodeEndpointDtos = Scanner.of((Iterable)this.getSpyClient(clientId).getAllNodeEndPoints()).map(nodeEndPoint -> new AwsMemcachedNodeEndpointDto(nodeEndPoint.getHostName(), nodeEndPoint.getIpAddress(), nodeEndPoint.getPort())).list();
            TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("HostName", AwsMemcachedNodeEndpointDto::hostName).withColumn("IpAddress", AwsMemcachedNodeEndpointDto::ipAddress).withColumn("Port", AwsMemcachedNodeEndpointDto::port).build((Collection)nodeEndpointDtos);
            DivTag divTable = (DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
            return new MemcachedWebInspector.MemcachedDetail(Integer.valueOf(nodeEndpointDtos.size()), divTable);
        }
        List socketAddresses = Scanner.of((Iterable)this.getSpyClient(clientId).getAvailableServers()).map(Object::toString).map(TagCreator::li).list();
        DivTag div = TagCreator.div((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])((DomContent[])socketAddresses.toArray(new ContainerTag[0])))});
        return new MemcachedWebInspector.MemcachedDetail(Integer.valueOf(socketAddresses.size()), div);
    }

    private record AwsMemcachedNodeEndpointDto(String hostName, String ipAddress, int port) {
    }
}

