/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.enums.StringMappedEnum;
import io.datarouter.storage.config.client.MemcachedGenericClientOptions;
import net.spy.memcached.ClientMode;

public enum MemcachedClientMode {
    STATIC(ClientMode.Static, "static"),
    DYNAMIC(ClientMode.Dynamic, "dynamic");

    public static final StringMappedEnum<MemcachedClientMode> BY_PERSISTENT_STRING;
    public final ClientMode clientMode;
    public final String persistentString;

    static {
        BY_PERSISTENT_STRING = new StringMappedEnum((Object[])MemcachedClientMode.values(), value -> value.persistentString);
    }

    private MemcachedClientMode(ClientMode clientMode, String persistentString) {
        this.clientMode = clientMode;
        this.persistentString = persistentString;
    }

    public static MemcachedClientMode fromGenericClientMode(MemcachedGenericClientOptions.MemcachedGenericClientMode genericMode) {
        return switch (genericMode) {
            case MemcachedGenericClientOptions.MemcachedGenericClientMode.STATIC -> STATIC;
            case MemcachedGenericClientOptions.MemcachedGenericClientMode.DYNAMIC -> DYNAMIC;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

