/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.aws.memcached.client.MemcachedClientMode;
import io.datarouter.aws.memcached.client.options.AwsMemcachedOptions;
import io.datarouter.client.memcached.client.BaseMemcachedClientManager;
import io.datarouter.client.memcached.client.DatarouterMemcachedClient;
import io.datarouter.client.memcached.client.MemcachedClientHolder;
import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.storage.client.ClientId;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.KetamaConnectionFactory;

@Singleton
public class AwsMemcachedClientManager
extends BaseMemcachedClientManager {
    @Inject
    private AwsMemcachedOptions options;

    @Inject
    public AwsMemcachedClientManager(MemcachedClientHolder clientHolder, AwsMemcachedOptions options) {
        super(clientHolder);
        this.options = options;
    }

    protected DatarouterMemcachedClient buildClient(ClientId clientId) {
        MemcachedClientMode clientMode = this.options.getClientMode(clientId.getName());
        KetamaConnectionFactory ketamaConnectionFactory = new KetamaConnectionFactory(clientMode.clientMode, 16384, 16384, DefaultConnectionFactory.DEFAULT_OP_QUEUE_MAX_BLOCK_TIME){

            public long getOperationTimeout() {
                return 200L;
            }
        };
        List addresses = clientMode == MemcachedClientMode.DYNAMIC ? this.options.getClusterEndpoint(clientId.getName()).map(List::of).get() : this.options.getServers(clientId.getName());
        try {
            SpyMemcachedClient spyClient = new SpyMemcachedClient((ConnectionFactory)ketamaConnectionFactory, addresses);
            return new DatarouterMemcachedClient(spyClient);
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("failed to build memcached client for " + addresses, e);
        }
    }
}

