/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client.options;

import io.datarouter.aws.memcached.client.MemcachedClientMode;
import io.datarouter.client.memcached.client.options.MemcachedOptions;
import io.datarouter.storage.client.ClientOptions;
import java.net.InetSocketAddress;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AwsMemcachedOptions
extends MemcachedOptions {
    public static final String PROP_clientMode = "clientMode";
    public static final String PROP_clusterEndpoint = "clusterEndpoint";
    @Inject
    private ClientOptions clientOptions;

    public MemcachedClientMode getClientMode(String clientName) {
        return this.clientOptions.optString(clientName, AwsMemcachedOptions.makeAwsMemcachedKey(PROP_clientMode)).map(arg_0 -> MemcachedClientMode.BY_PERSISTENT_STRING.from(arg_0)).filter(Optional::isPresent).map(Optional::get).orElse(MemcachedClientMode.STATIC);
    }

    public Optional<InetSocketAddress> getClusterEndpoint(String clientName) {
        return this.clientOptions.optInetSocketAddress(clientName, AwsMemcachedOptions.makeAwsMemcachedKey(PROP_clusterEndpoint));
    }

    public static String makeAwsMemcachedKey(String propertyKey) {
        return "awsMemcached." + propertyKey;
    }
}

