/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client.options;

import io.datarouter.aws.memcached.client.MemcachedClientMode;
import io.datarouter.aws.memcached.client.options.AwsMemcachedOptions;
import io.datarouter.client.memcached.client.options.MemcachedClientOptionsBuilder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.client.MemcachedGenericClientOptions;
import java.util.Optional;
import java.util.Properties;

public class AwsMemcachedClientOptionsBuilder
extends MemcachedClientOptionsBuilder {
    public AwsMemcachedClientOptionsBuilder(ClientId clientId) {
        super(clientId, "awsMemcached");
    }

    public AwsMemcachedClientOptionsBuilder(MemcachedGenericClientOptions genericOptions) {
        this(genericOptions.clientId);
        this.withClientMode(MemcachedClientMode.fromGenericClientMode(genericOptions.clientMode));
        Optional.ofNullable(genericOptions.servers).ifPresent(arg_0 -> ((AwsMemcachedClientOptionsBuilder)this).withServers(arg_0));
        Optional.ofNullable(genericOptions.clusterEndpoint).ifPresent(this::withClusterEndpoint);
    }

    public AwsMemcachedClientOptionsBuilder withClientMode(MemcachedClientMode clientMode) {
        String optionKeySuffix = AwsMemcachedOptions.makeAwsMemcachedKey("clientMode");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clientMode.getPersistentString());
        return this;
    }

    public AwsMemcachedClientOptionsBuilder withClusterEndpoint(String clusterEndpoint) {
        String optionKeySuffix = AwsMemcachedOptions.makeAwsMemcachedKey("clusterEndpoint");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clusterEndpoint);
        return this;
    }

    public Properties build() {
        return this.properties;
    }
}

