/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.memcached.client;

import io.datarouter.enums.PersistentString;
import io.datarouter.enums.StringEnum;
import io.datarouter.storage.config.client.MemcachedGenericClientOptions;
import java.util.Optional;
import net.spy.memcached.ClientMode;

public enum MemcachedClientMode implements StringEnum<MemcachedClientMode>
{
    STATIC(ClientMode.Static, "static"),
    DYNAMIC(ClientMode.Dynamic, "dynamic");

    private final ClientMode clientMode;
    private final String persistentString;

    private MemcachedClientMode(ClientMode clientMode, String persistentString) {
        this.clientMode = clientMode;
        this.persistentString = persistentString;
    }

    public static MemcachedClientMode fromGenericClientMode(MemcachedGenericClientOptions.MemcachedGenericClientMode genericMode) {
        return switch (genericMode) {
            case MemcachedGenericClientOptions.MemcachedGenericClientMode.STATIC -> STATIC;
            case MemcachedGenericClientOptions.MemcachedGenericClientMode.DYNAMIC -> DYNAMIC;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public ClientMode getClientMode() {
        return this.clientMode;
    }

    public String getPersistentString() {
        return this.persistentString;
    }

    public MemcachedClientMode fromPersistentString(String string) {
        return MemcachedClientMode.fromPersistentStringStatic(string).orElseThrow();
    }

    public static Optional<MemcachedClientMode> fromPersistentStringStatic(String string) {
        return StringEnum.findEnumFromString((PersistentString[])MemcachedClientMode.values(), (String)string);
    }
}

