/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.service;

import io.datarouter.autoconfig.config.DatarouterAutoConfigExecutors;
import io.datarouter.autoconfig.service.AutoConfig;
import io.datarouter.autoconfig.service.AutoConfigGroup;
import io.datarouter.plugin.PluginInjector;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AutoConfigService {
    private final Map<String, Callable<String>> autoConfigByName = new HashMap<String, Callable<String>>();
    private final ServerTypeDetector serverTypeDetector;
    private final DatarouterAutoConfigExecutors.AutoConfigExecutor executor;

    @Inject
    public AutoConfigService(PluginInjector pluginInjector, ServerTypeDetector serverTypeDetector, DatarouterAutoConfigExecutors.AutoConfigExecutor executor) {
        this.serverTypeDetector = serverTypeDetector;
        this.executor = executor;
        pluginInjector.getInstances(AutoConfig.KEY).forEach(autoConfig -> {
            Callable<String> callable = this.autoConfigByName.put(autoConfig.getName(), (Callable<String>)autoConfig);
        });
        pluginInjector.getInstances(AutoConfigGroup.KEY).forEach(autoConfigGroup -> {
            Callable<String> callable = this.autoConfigByName.put(autoConfigGroup.getName(), (Callable<String>)autoConfigGroup);
        });
    }

    public Map<String, Callable<String>> getAutoConfigByName() {
        return this.autoConfigByName;
    }

    public String runAutoConfigAll() {
        this.serverTypeDetector.assertNotProductionServer();
        return (String)Scanner.of(this.getAutoConfigByName().entrySet()).map(Map.Entry::getValue).parallel(new ParallelScannerContext((ExecutorService)((Object)this.executor), 8, true)).map(callable -> {
            try {
                return (String)callable.call();
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.joining("\n"));
    }

    public String runAutoConfigForName(String name) throws Exception {
        this.serverTypeDetector.assertNotProductionServer();
        Callable<String> callable = this.autoConfigByName.get(name);
        return callable.call();
    }
}

