/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.service;

import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigType;
import io.datarouter.plugin.PluginConfigValue;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AutoConfigGroup
extends Callable<String>,
PluginConfigValue<AutoConfigGroup> {
    public static final Logger logger = LoggerFactory.getLogger(AutoConfigGroup.class);
    public static final PluginConfigKey<AutoConfigGroup> KEY = new PluginConfigKey("autoConfigGroup", PluginConfigType.CLASS_LIST);
    public static final String NEW_LINE = "\n";
    public static final String MARKER = "===============================================================================";

    public String getName();

    public List<String> configure();

    @Override
    default public String call() {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append(MARKER).append(NEW_LINE);
        sb.append(this.getName()).append(NEW_LINE);
        try {
            this.configure().forEach(action -> {
                StringBuilder stringBuilder2 = sb.append(" - ").append((String)action).append(NEW_LINE);
            });
        }
        catch (Exception e) {
            sb.append(" - Error: ").append(e.getMessage());
        }
        sb.append(NEW_LINE);
        logger.warn(sb.toString());
        return sb.toString();
    }

    default public PluginConfigKey<AutoConfigGroup> getKey() {
        return KEY;
    }
}

