/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.service;

import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigType;
import io.datarouter.plugin.PluginConfigValue;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AutoConfig
extends Callable<String>,
PluginConfigValue<AutoConfig> {
    public static final Logger logger = LoggerFactory.getLogger(AutoConfig.class);
    public static final PluginConfigKey<AutoConfig> KEY = new PluginConfigKey("autoConfig", PluginConfigType.CLASS_LIST);
    public static final String NEW_LINE = "\n";
    public static final String MARKER = "===============================================================================";

    public String getName();

    public String configure();

    @Override
    default public String call() {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append(MARKER).append(NEW_LINE);
        sb.append(this.getName()).append(NEW_LINE);
        try {
            sb.append(" - ").append(this.configure()).append(NEW_LINE);
        }
        catch (Exception e) {
            sb.append(" - Error: ").append(e.getMessage());
        }
        sb.append(NEW_LINE);
        logger.warn(sb.toString());
        return sb.toString();
    }

    default public PluginConfigKey<AutoConfig> getKey() {
        return KEY;
    }
}

