/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterUserByUsernameCache;
import io.datarouter.auth.service.DatarouterUserCreationService;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.BooleanTool;
import io.datarouter.web.exception.InvalidCredentialsException;
import io.datarouter.web.user.BaseDatarouterSessionDao;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.DatarouterSession;
import io.datarouter.web.user.session.DatarouterSessionKey;
import io.datarouter.web.user.session.DatarouterSessionManager;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.user.session.service.SessionBasedUser;
import io.datarouter.web.user.session.service.UserSessionService;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class DatarouterUserSessionService
implements UserSessionService {
    @Inject
    private DatarouterUserDao userDao;
    @Inject
    private BaseDatarouterSessionDao sessionDao;
    @Inject
    private DatarouterSessionManager sessionManager;
    @Inject
    private DatarouterUserCreationService userCreationService;
    @Inject
    private DatarouterUserByUsernameCache cache;

    public void setSessionCookies(HttpServletResponse response, Session session) {
        this.sessionManager.addUserTokenCookie(response, session.getUserToken());
        this.sessionManager.addSessionTokenCookie(response, session.getSessionToken());
    }

    public void clearSessionCookies(HttpServletResponse response) {
        this.sessionManager.clearUserTokenCookie(response);
        this.sessionManager.clearSessionTokenCookie(response);
    }

    public Optional<Session> signInUserWithRoles(HttpServletRequest request, String username, Set<Role> roles) {
        DatarouterUser user = this.cache.get(username).orElse(null);
        if (user == null) {
            return Optional.empty();
        }
        if (BooleanTool.isFalseOrNull((Boolean)user.getEnabled())) {
            throw new InvalidCredentialsException("user not enabled (" + username + ")");
        }
        user.setLastLoggedIn(Instant.now());
        user.setRoles(Scanner.concat((Iterable[])new Iterable[]{roles, user.getRoles()}).collect(HashSet::new));
        this.userDao.put(user);
        DatarouterSession session = DatarouterSession.createFromUser((DatarouterUser)user);
        this.sessionDao.put(session);
        return Optional.of(session);
    }

    public SessionBasedUser createAuthorizedUser(String username, String description, Set<Role> roles) {
        return this.userCreationService.createAutomaticUser(username, description, roles);
    }

    public void deleteSession(HttpServletRequest request) {
        Optional.ofNullable(this.sessionManager.getSessionTokenFromCookie(request)).map(DatarouterSessionKey::new).ifPresent(arg_0 -> ((BaseDatarouterSessionDao)this.sessionDao).delete(arg_0));
    }

    public void deleteUserSessions(List<String> usernames) {
        HashSet<String> usernameSet = new HashSet<String>(usernames);
        this.sessionDao.scan().include(session -> usernameSet.contains(session.getUsername())).map(BaseDatabean::getKey).flush(arg_0 -> ((BaseDatarouterSessionDao)this.sessionDao).deleteMulti(arg_0));
    }

    public Optional<ZoneId> getZoneId(String username) {
        return this.userDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username)).getZoneId();
    }
}

