/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.DatarouterAccountSecretCredentialKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.util.DateTool;
import io.datarouter.web.util.PasswordTool;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class DatarouterAccountSecretCredential
extends BaseDatabean<DatarouterAccountSecretCredentialKey, DatarouterAccountSecretCredential> {
    private String secretNamespace;
    private String accountName;
    private Date created;
    private String creatorUsername;
    private Date lastUsed;
    private Boolean active;

    public DatarouterAccountSecretCredential() {
        super((PrimaryKey)new DatarouterAccountSecretCredentialKey());
    }

    public DatarouterAccountSecretCredential(String secretName, String secretNamespace, String accountName, String creatorUsername) {
        super((PrimaryKey)new DatarouterAccountSecretCredentialKey(secretName));
        this.secretNamespace = secretNamespace;
        this.accountName = accountName;
        this.created = new Date();
        this.creatorUsername = creatorUsername;
        this.active = true;
    }

    public static DatarouterAccountSecretCredential create(String secretNamespace, String accountName, String creatorUsername) {
        return new DatarouterAccountSecretCredential(PasswordTool.generateSalt(), secretNamespace, accountName, creatorUsername);
    }

    public Class<DatarouterAccountSecretCredentialKey> getKeyClass() {
        return DatarouterAccountSecretCredentialKey.class;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getSecretNamespace() {
        return this.secretNamespace;
    }

    public String getCreatedDate(ZoneId zoneId) {
        if (this.created == null) {
            return "";
        }
        return DateTool.formatDateWithZone((Date)this.created, (ZoneId)zoneId);
    }

    public String getCreatorUsername() {
        return this.creatorUsername;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String getLastUsedDate(ZoneId zoneId) {
        if (this.lastUsed == null) {
            return "";
        }
        return DateTool.formatDateWithZone((Date)this.lastUsed, (ZoneId)zoneId);
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public static class DatarouterAccountSecretCredentialFielder
    extends BaseDatabeanFielder<DatarouterAccountSecretCredentialKey, DatarouterAccountSecretCredential> {
        public DatarouterAccountSecretCredentialFielder() {
            super(DatarouterAccountSecretCredentialKey.class);
        }

        public List<Field<?>> getNonKeyFields(DatarouterAccountSecretCredential credential) {
            return List.of(new StringField(FieldKeys.secretNamespace, credential.getSecretNamespace()), new StringField(FieldKeys.accountName, credential.accountName), new DateField(FieldKeys.created, credential.created), new StringField(FieldKeys.creatorUsername, credential.creatorUsername), new DateField(FieldKeys.lastUsed, credential.lastUsed), new BooleanField(FieldKeys.active, credential.active));
        }
    }

    static class FieldKeys {
        private static final StringFieldKey secretNamespace = new StringFieldKey("secretNamespace");
        private static final StringFieldKey accountName = new StringFieldKey("accountName");
        private static final DateFieldKey created = new DateFieldKey("created");
        private static final StringFieldKey creatorUsername = new StringFieldKey("creatorUsername");
        private static final DateFieldKey lastUsed = new DateFieldKey("lastUsed");
        private static final BooleanFieldKey active = new BooleanFieldKey("active");

        FieldKeys() {
        }
    }
}

