/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.user.session.service.SessionBasedUser;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountUserService {
    private final BaseDatarouterAccountDao datarouterAccountDao;
    private final BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    private final BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao;

    @Inject
    public DatarouterAccountUserService(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao, BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao) {
        this.datarouterAccountDao = datarouterAccountDao;
        this.datarouterAccountCredentialDao = datarouterAccountCredentialDao;
        this.datarouterUserAccountMapDao = datarouterUserAccountMapDao;
    }

    public List<String> getAllAccountNamesWithUserMappingsEnabled() {
        return this.datarouterAccountDao.scan().include(DatarouterAccount::getEnableUserMappings).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).list();
    }

    public boolean userCanAccessAccount(Session session, String accountName) {
        if (!this.userCanAccessAccount(session.getUserId(), accountName)) {
            return false;
        }
        return this.datarouterAccountDao.find(new DatarouterAccountKey(accountName)).map(DatarouterAccount::getEnableUserMappings).orElse(false);
    }

    private boolean userCanAccessAccount(Long userId, String accountName) {
        if (userId == null) {
            return false;
        }
        DatarouterUserAccountMapKey key = new DatarouterUserAccountMapKey(userId, accountName);
        return this.datarouterUserAccountMapDao.exists(key);
    }

    public Set<String> findAccountNamesForUser(SessionBasedUser user) {
        return (Set)this.scanAccountNamesForUserIdWithUserMappingEnabled(user.getId()).collect(HashSet::new);
    }

    public Set<String> findAccountNamesForUser(Session session) {
        return (Set)this.scanAccountNamesForUserIdWithUserMappingEnabled(session.getUserId()).collect(HashSet::new);
    }

    public Optional<DatarouterAccountCredential> findFirstAccountCredentialForUser(Session session) {
        Set<String> accountsForUser = this.findAccountNamesForUser(session);
        if (accountsForUser.isEmpty()) {
            return Optional.empty();
        }
        return this.datarouterAccountCredentialDao.scanByAccountName(accountsForUser).findFirst();
    }

    public Scanner<DatarouterAccount> scanAccountsForUser(Session session) {
        return this.scanAccountsForUserIdWithUserMappingEnabled(session.getUserId());
    }

    private Scanner<String> scanAccountNamesForUserIdWithUserMappingEnabled(Long userId) {
        if (userId == null) {
            return Scanner.empty();
        }
        return this.scanAccountsForUserIdWithUserMappingEnabled(userId).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName);
    }

    private Scanner<DatarouterAccount> scanAccountsForUserIdWithUserMappingEnabled(Long userId) {
        if (userId == null) {
            return Scanner.empty();
        }
        DatarouterUserAccountMapKey prefix = new DatarouterUserAccountMapKey(userId, null);
        return ((Scanner)this.datarouterUserAccountMapDao.scanKeysWithPrefix(prefix).map(DatarouterUserAccountMapKey::getDatarouterAccountKey).listTo(this.datarouterAccountDao::scanMulti)).include(DatarouterAccount::getEnableUserMappings);
    }
}

