/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.util.DateTool;
import io.datarouter.web.util.PasswordTool;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class DatarouterAccountCredential
extends BaseDatabean<DatarouterAccountCredentialKey, DatarouterAccountCredential> {
    private String accountName;
    private String secretKey;
    private Date created;
    private String creatorUsername;
    private Date lastUsed;
    private Boolean enableUserMappings;

    public DatarouterAccountCredential() {
        super((PrimaryKey)new DatarouterAccountCredentialKey());
    }

    public DatarouterAccountCredential(String apiKey, String secretKey, String accountName, String creatorUsername) {
        super((PrimaryKey)new DatarouterAccountCredentialKey(apiKey));
        this.secretKey = secretKey;
        this.accountName = accountName;
        this.created = new Date();
        this.creatorUsername = creatorUsername;
    }

    public static DatarouterAccountCredential create(String accountName, String creatorUsername) {
        return new DatarouterAccountCredential(PasswordTool.generateSalt(), PasswordTool.generateSalt(), accountName, creatorUsername);
    }

    public Class<DatarouterAccountCredentialKey> getKeyClass() {
        return DatarouterAccountCredentialKey.class;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCreatedDate(ZoneId zoneId) {
        if (this.created == null) {
            return "";
        }
        return DateTool.formatDateWithZone((Date)this.created, (ZoneId)zoneId);
    }

    public String getCreatorUsername() {
        return this.creatorUsername;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String getLastUsedDate(ZoneId zoneId) {
        if (this.lastUsed == null) {
            return "";
        }
        return DateTool.formatDateWithZone((Date)this.lastUsed, (ZoneId)zoneId);
    }

    public static class DatarouterAccountCredentialFielder
    extends BaseDatabeanFielder<DatarouterAccountCredentialKey, DatarouterAccountCredential> {
        public DatarouterAccountCredentialFielder() {
            super(DatarouterAccountCredentialKey.class);
        }

        public List<Field<?>> getNonKeyFields(DatarouterAccountCredential account) {
            return List.of(new StringField(FieldKeys.accountName, account.accountName), new StringField(FieldKeys.secretKey, account.secretKey), new DateField(FieldKeys.created, account.created), new StringField(FieldKeys.creatorUsername, account.creatorUsername), new DateField(FieldKeys.lastUsed, account.lastUsed), new BooleanField(FieldKeys.enableUserMappings, account.enableUserMappings));
        }
    }

    static class FieldKeys {
        static final StringFieldKey accountName = new StringFieldKey("accountName");
        private static final StringFieldKey secretKey = new StringFieldKey("secretKey");
        private static final DateFieldKey created = new DateFieldKey("created");
        private static final StringFieldKey creatorUsername = new StringFieldKey("creatorUsername");
        private static final DateFieldKey lastUsed = new DateFieldKey("lastUsed");
        private static final BooleanFieldKey enableUserMappings = new BooleanFieldKey("enableUserMappings");

        FieldKeys() {
        }
    }
}

