/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.user.detail.DatarouterUserExternalDetailService;
import io.datarouter.web.user.session.service.SessionBasedUser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;

@Singleton
public class PermissionRequestDailyDigest
implements DailyDigest {
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;
    @Inject
    private ServletContextSupplier servletContextSupplier;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterUserExternalDetailService detailsService;
    @Inject
    private UserInfo userInfo;
    @Inject
    private DailyDigestService digestService;

    public Optional<ContainerTag> getPageContent() {
        List<? extends SessionBasedUser> openRequests = this.getOpenRequests();
        if (openRequests.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Open Permission Requests", this.paths.admin.viewUsers);
        ContainerTag table = this.buildPageTable(openRequests);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public Optional<ContainerTag> getEmailContent() {
        List<? extends SessionBasedUser> openRequests = this.getOpenRequests();
        if (openRequests.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Open Permission Requests", this.paths.admin.viewUsers);
        ContainerTag table = this.buildEmailTable(openRequests);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public String getTitle() {
        return "Permission Requests";
    }

    private List<? extends SessionBasedUser> getOpenRequests() {
        return this.permissionRequestDao.scanOpenPermissionRequests().map(BaseDatabean::getKey).map(DatarouterPermissionRequestKey::getUserId).map(id -> this.userInfo.getUserById((Long)id, true)).include(Optional::isPresent).map(Optional::get).list();
    }

    private <T extends SessionBasedUser> ContainerTag buildPageTable(List<T> rows) {
        return new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withColumn("Username", row -> row.getUsername()).withHtmlColumn("Profile", row -> {
            String detailsLink = (String)this.detailsService.getUserProfileUrl(row.getUsername()).get();
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)detailsLink).withHref(detailsLink)});
        }).withHtmlColumn("Details", row -> {
            String link = String.valueOf(((ServletContext)this.servletContextSupplier.get()).getContextPath()) + this.paths.admin.editUser.toSlashedString() + "?username=" + row.getUsername();
            return TagCreator.td((DomContent[])new DomContent[]{((ContainerTag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fa fa-link")}).withClass("btn btn-link w-100 py-0")).withHref(link)});
        }).build(rows);
    }

    private <T extends SessionBasedUser> ContainerTag buildEmailTable(List<T> rows) {
        return new J2HtmlEmailTable().withColumn("Username", row -> row.getUsername()).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Profile", row -> {
            String detailsLink = (String)this.detailsService.getUserProfileUrl(row.getUsername()).get();
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)detailsLink).withHref(detailsLink)});
        })).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Details", row -> {
            String link = String.valueOf(((ServletContext)this.servletContextSupplier.get()).getContextPath()) + this.paths.admin.editUser.toSlashedString() + "?username=" + row.getUsername();
            return TagCreator.a((String)"Edit User Page").withHref(link);
        })).build(rows);
    }
}

