/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountService;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.httpclient.security.DefaultSignatureGenerator;
import io.datarouter.web.security.DefaultSignatureValidator;
import io.datarouter.web.security.SecurityValidationResult;
import io.datarouter.web.security.SignatureValidator;
import io.datarouter.web.util.http.RequestTool;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterAccountSignatureValidator
implements SignatureValidator {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountSignatureValidator.class);
    @Inject
    private DatarouterAccountService datarouterAccountService;

    public SecurityValidationResult validate(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        Optional<DatarouterAccount> account = this.datarouterAccountService.findAccountForApiKey(apiKey);
        if (account.isEmpty()) {
            logger.warn("Missing account for apiKey={}", (Object)apiKey);
        }
        return account.map(DatarouterAccount::getSecretKey).map(secretKey -> () -> secretKey).map(DefaultSignatureGenerator::new).map(DefaultSignatureValidator::new).map(signatureValidator -> signatureValidator.validate(request)).orElse(SecurityValidationResult.failure((HttpServletRequest)request));
    }
}

