/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.config.DatarouterAuthExecutors;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountDao
extends BaseDao
implements BaseDatarouterAccountDao {
    private final SortedMapStorage<DatarouterAccountKey, DatarouterAccount> node;
    private final AtomicReference<Map<String, DatarouterAccount>> accountByApiKeyCache;

    @Inject
    public DatarouterAccountDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterAccountDaoParams params, DatarouterAuthExecutors.DatarouterAccountByApiKeyCacheExecutor executor) {
        super(datarouter);
        this.node = (SortedMapStorage)nodeFactory.create(params.clientId, DatarouterAccount::new, DatarouterAccount.DatarouterAccountFielder::new).buildAndRegister();
        this.accountByApiKeyCache = new AtomicReference<Map<String, DatarouterAccount>>(this.getAccountsByApiKey());
        executor.scheduleWithFixedDelay(this::refreshAccountByApiKeyCache, 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void put(DatarouterAccount databean) {
        this.node.put((Databean)databean);
    }

    @Override
    public void putMulti(Collection<DatarouterAccount> databeans) {
        this.node.putMulti(databeans);
    }

    @Override
    public DatarouterAccount get(DatarouterAccountKey key) {
        return (DatarouterAccount)this.node.get((PrimaryKey)key);
    }

    @Override
    public List<DatarouterAccount> getMulti(Collection<DatarouterAccountKey> keys) {
        return this.node.getMulti(keys);
    }

    @Override
    public Scanner<DatarouterAccount> scan() {
        return this.node.scan();
    }

    @Override
    public Scanner<DatarouterAccountKey> scanKeys() {
        return this.node.scanKeys();
    }

    @Override
    public boolean exists(DatarouterAccountKey key) {
        return this.node.exists((PrimaryKey)key);
    }

    @Override
    public void delete(DatarouterAccountKey key) {
        this.node.delete((PrimaryKey)key);
    }

    @Override
    public Optional<DatarouterAccount> find(DatarouterAccountKey key) {
        return this.node.find((PrimaryKey)key);
    }

    @Override
    public Optional<DatarouterAccount> getFromAccountByApiKeyCache(String apiKey) {
        return Optional.ofNullable(this.accountByApiKeyCache.get().get(apiKey));
    }

    private Map<String, DatarouterAccount> getAccountsByApiKey() {
        return this.node.scan().toMap(DatarouterAccount::getApiKey);
    }

    private void refreshAccountByApiKeyCache() {
        this.accountByApiKeyCache.set(this.getAccountsByApiKey());
    }

    public static class DatarouterAccountDaoParams
    extends BaseDaoParams {
        public DatarouterAccountDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

