/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.permissionrequest;

import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterPermissionRequestDao
extends BaseDao {
    private final SortedMapStorage<DatarouterPermissionRequestKey, DatarouterPermissionRequest> node;

    @Inject
    public DatarouterPermissionRequestDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterPermissionRequestDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage)nodeFactory.create(params.clientId, DatarouterPermissionRequest::new, DatarouterPermissionRequest.DatarouterPermissionRequestFielder::new).buildAndRegister();
    }

    public void putMulti(Collection<DatarouterPermissionRequest> databeans) {
        this.node.putMulti(databeans);
    }

    public Scanner<DatarouterPermissionRequest> scan() {
        return this.node.scan();
    }

    public Scanner<DatarouterPermissionRequest> scanWithPrefix(DatarouterPermissionRequestKey prefix) {
        return this.node.scanWithPrefix((PrimaryKey)prefix);
    }

    public Scanner<DatarouterPermissionRequest> scanOpenPermissionRequests() {
        return this.scan().include(request -> request.getResolution() == null);
    }

    public Scanner<DatarouterPermissionRequest> scanOpenPermissionRequestsForUser(Long userId) {
        Objects.requireNonNull(userId);
        return this.scanPermissionRequestsForUser(userId).include(request -> request.getResolution() == null);
    }

    public Scanner<DatarouterPermissionRequest> scanPermissionRequestsForUser(Long userId) {
        return this.scanWithPrefix(new DatarouterPermissionRequestKey(userId, null));
    }

    public void createPermissionRequest(DatarouterPermissionRequest request) {
        List requestsToPut = this.scanOpenPermissionRequestsForUser(((DatarouterPermissionRequestKey)request.getKey()).getUserId()).map(DatarouterPermissionRequest::supercede).list();
        requestsToPut.add(request);
        this.putMulti(requestsToPut);
    }

    public void declineAll(Long userId) {
        this.scanOpenPermissionRequestsForUser(userId).map(DatarouterPermissionRequest::decline).flush(this::putMulti);
    }

    public Set<Long> getUserIdsWithPermissionRequests() {
        return (Set)this.scanOpenPermissionRequests().map(BaseDatabean::getKey).map(DatarouterPermissionRequestKey::getUserId).collect(HashSet::new);
    }

    public static class DatarouterPermissionRequestDaoParams
    extends BaseDaoParams {
        public DatarouterPermissionRequestDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

