/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.deprovisioneduser;

import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.web.deprovisioning.DeprovisionedUserDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.array.DelimitedStringArrayField;
import io.datarouter.model.field.imp.array.DelimitedStringArrayFieldKey;
import io.datarouter.model.field.imp.enums.StringEnumField;
import io.datarouter.model.field.imp.enums.StringEnumFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.PersistentString;
import io.datarouter.util.enums.StringEnum;
import io.datarouter.web.user.session.service.Role;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DeprovisionedUser
extends BaseDatabean<DeprovisionedUserKey, DeprovisionedUser> {
    private List<String> roles;
    private UserDeprovisioningStatus status;

    public DeprovisionedUser() {
        super((PrimaryKey)new DeprovisionedUserKey(null));
    }

    public DeprovisionedUser(String username, Collection<Role> roles, UserDeprovisioningStatus status) {
        super((PrimaryKey)new DeprovisionedUserKey(username));
        this.setRoles(roles);
        this.status = status;
    }

    public DeprovisionedUserDto toDto() {
        return new DeprovisionedUserDto(this.getUsername(), Scanner.of(this.roles).sorted(String.CASE_INSENSITIVE_ORDER).list(), this.status.dto);
    }

    public Class<DeprovisionedUserKey> getKeyClass() {
        return DeprovisionedUserKey.class;
    }

    public String getUsername() {
        return ((DeprovisionedUserKey)this.getKey()).getUsername();
    }

    public Set<Role> getRoles() {
        return this.roles.stream().map(Role::new).collect(Collectors.toSet());
    }

    public void setRoles(Collection<Role> roles) {
        this.roles = roles.stream().map(Role::getPersistentString).sorted().distinct().collect(Collectors.toList());
    }

    public UserDeprovisioningStatus getStatus() {
        return this.status;
    }

    public static class DeprovisionedUserFielder
    extends BaseDatabeanFielder<DeprovisionedUserKey, DeprovisionedUser> {
        public DeprovisionedUserFielder() {
            super(DeprovisionedUserKey.class);
        }

        public List<Field<?>> getNonKeyFields(DeprovisionedUser user) {
            return Arrays.asList(new DelimitedStringArrayField(FieldKeys.roles, user.roles), new StringEnumField(FieldKeys.status, (StringEnum)user.status));
        }
    }

    public static class FieldKeys {
        public static final DelimitedStringArrayFieldKey roles = new DelimitedStringArrayFieldKey("roles");
        public static final StringEnumFieldKey<UserDeprovisioningStatus> status = new StringEnumFieldKey("status", UserDeprovisioningStatus.class);
    }

    public static enum UserDeprovisioningStatus implements StringEnum<UserDeprovisioningStatus>
    {
        DEPROVISIONED("deprovisioned", DeprovisionedUserDto.UserDeprovisioningStatusDto.DEPROVISIONED),
        FLAGGED("flagged", DeprovisionedUserDto.UserDeprovisioningStatusDto.FLAGGED);

        private final String persistentString;
        public final DeprovisionedUserDto.UserDeprovisioningStatusDto dto;

        private UserDeprovisioningStatus(String persistentString, DeprovisionedUserDto.UserDeprovisioningStatusDto dto) {
            this.persistentString = persistentString;
            this.dto = dto;
        }

        public String getPersistentString() {
            return this.persistentString;
        }

        public UserDeprovisioningStatus fromPersistentString(String string) {
            return UserDeprovisioningStatus.fromPersistentStringStatic(string);
        }

        public static UserDeprovisioningStatus fromPersistentStringStatic(String string) {
            return (UserDeprovisioningStatus)DatarouterEnumTool.getEnumFromString((PersistentString[])UserDeprovisioningStatus.values(), (String)string, null);
        }
    }
}

