/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.client;

import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.httpclient.client.DatarouterHttpClientBuilder;
import io.datarouter.httpclient.client.DatarouterHttpClientSettings;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.duration.DatarouterDuration;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class BaseDatarouterClientSettings
extends SettingNode
implements DatarouterHttpClientSettings {
    public final CachedSetting<String> endpointDomain;
    public final CachedSetting<String> endpointPath;
    public final CachedSetting<String> apiKey;
    public final CachedSetting<String> privateKey;
    public final CachedSetting<DatarouterDuration> timeout;
    public final CachedSetting<Integer> numRetries;
    public final CachedSetting<Boolean> enableBreakers;

    public BaseDatarouterClientSettings(SettingFinder finder, DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys, String settingNodeName, DatarouterService service, DefaultSettingValue<String> endpointDomainDefaults) {
        super(finder, settingNodeName);
        this.endpointDomain = this.registerStrings("endpointDomain", endpointDomainDefaults);
        this.endpointPath = this.registerString("endpointPath", service.getContextPath());
        this.apiKey = this.registerString("apiKey", defaultDatarouterAccountKeys.getDefaultApiKey());
        this.privateKey = this.registerString("privateKey", defaultDatarouterAccountKeys.getDefaultSecretKey());
        this.timeout = this.registerDurations("timeout", BaseDatarouterClientSettings.defaultTo((Object)new DatarouterDuration(this.getTimeoutDefault().toMillis(), TimeUnit.MILLISECONDS)));
        this.numRetries = this.registerIntegers("numRetries", BaseDatarouterClientSettings.defaultTo((Object)this.getNumRetriesDefault()));
        this.enableBreakers = this.registerBooleans("enableBreakers", this.getEnableBreakersDefault());
    }

    public URI getEndpointUrl() {
        return URI.create("https://" + (String)this.endpointDomain.get() + (String)this.endpointPath.get());
    }

    public String getApiKey() {
        return (String)this.apiKey.get();
    }

    public String getPrivateKey() {
        return (String)this.privateKey.get();
    }

    public final Duration getTimeout() {
        return ((DatarouterDuration)this.timeout.get()).toJavaDuration();
    }

    public final Supplier<Integer> getNumRetries() {
        return this.numRetries;
    }

    public final Supplier<Boolean> getEnableBreakers() {
        return this.enableBreakers;
    }

    protected Duration getTimeoutDefault() {
        return DatarouterHttpClientBuilder.DEFAULT_TIMEOUT;
    }

    protected Integer getNumRetriesDefault() {
        return 1;
    }

    protected DefaultSettingValue<Boolean> getEnableBreakersDefault() {
        return BaseDatarouterClientSettings.defaultTo((Object)false);
    }
}

