/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DatarouterAccountAvailableEndpointsProvider;
import io.datarouter.auth.service.DefaultDatarouterAccountAvailableEndpointsProvider;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJs;
import io.datarouter.web.user.session.CurrentUserSessionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public class DatarouterAccountManagerHandler
extends BaseHandler {
    private final BaseDatarouterAccountDao datarouterAccountDao;
    private final BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao;
    private final DatarouterProperties datarouterProperties;
    private final DatarouterAuthFiles files;
    private final CurrentUserSessionInfo currentUserInfo;
    private final DatarouterAccountAvailableEndpointsProvider datarouterAccountAvailableEndpointsProvider;
    private final Bootstrap4ReactPageFactory reactPageFactory;
    private final DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;
    private final String path;

    @Inject
    public DatarouterAccountManagerHandler(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao, DatarouterProperties datarouterProperties, DatarouterAuthFiles files, DatarouterAuthPaths paths, CurrentUserSessionInfo currentUserInfo, DefaultDatarouterAccountAvailableEndpointsProvider defaultDatarouterAccountAvailableEndpointsProvider, Bootstrap4ReactPageFactory reactPageFactory, DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys) {
        this(datarouterAccountDao, datarouterAccountPermissionDao, datarouterProperties, files, currentUserInfo, defaultDatarouterAccountAvailableEndpointsProvider, reactPageFactory, defaultDatarouterAccountKeys, paths.admin.accounts.toSlashedString());
    }

    protected DatarouterAccountManagerHandler(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao, DatarouterProperties datarouterProperties, DatarouterAuthFiles files, CurrentUserSessionInfo currentUserInfo, DatarouterAccountAvailableEndpointsProvider datarouterAccountAvailableEndpointsProvider, Bootstrap4ReactPageFactory reactPageFactory, DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys, String path) {
        this.datarouterAccountDao = datarouterAccountDao;
        this.datarouterAccountPermissionDao = datarouterAccountPermissionDao;
        this.datarouterProperties = datarouterProperties;
        this.files = files;
        this.currentUserInfo = currentUserInfo;
        this.datarouterAccountAvailableEndpointsProvider = datarouterAccountAvailableEndpointsProvider;
        this.reactPageFactory = reactPageFactory;
        this.defaultDatarouterAccountKeys = defaultDatarouterAccountKeys;
        this.path = path;
    }

    @BaseHandler.Handler(defaultHandler=true)
    public Mav index() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter Account Manager").withRequires(new String[]{DatarouterWebRequireJs.SORTTABLE}).withReactScript(this.files.js.accountManagerJsx).withJsStringConstant("REACT_BASE_PATH", String.valueOf(this.request.getContextPath()) + this.path + "/").buildMav();
    }

    @BaseHandler.Handler
    public List<DatarouterAccountDetails> list() {
        return this.datarouterAccountDao.scan().map(this::getDetailsForAccount).list();
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails getDetails(String accountName) {
        DatarouterAccount account = this.datarouterAccountDao.get(new DatarouterAccountKey(accountName));
        List permissions = this.datarouterAccountPermissionDao.scanKeysWithPrefix(new DatarouterAccountPermissionKey(accountName)).map(TextPermission::create).list();
        return new DatarouterAccountDetails(account, permissions);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails add(String accountName) {
        Require.isTrue((!accountName.isEmpty() ? 1 : 0) != 0);
        String creator = this.currentUserInfo.getRequiredSession((ServletRequest)this.request).getUsername();
        DatarouterAccount account = new DatarouterAccount(accountName, new Date(), creator);
        this.datarouterAccountDao.put(account);
        return this.getDetailsForAccount(account);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails resetApiKeyToDefault(String accountName) throws Exception {
        if (!this.isServerTypeDev()) {
            throw new Exception("Default apiKey is only allowed for dev serverType.");
        }
        return this.updateAccount(accountName, account -> account.resetApiKeyToDefault(this.defaultDatarouterAccountKeys.getDefaultApiKey()));
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails resetSecretKeyToDefault(String accountName) throws Exception {
        if (!this.isServerTypeDev()) {
            throw new Exception("Default secretKey is only allowed for dev serverType.");
        }
        return this.updateAccount(accountName, account -> account.resetSecretKeyToDefault(this.defaultDatarouterAccountKeys.getDefaultSecretKey()));
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails generateApiKey(String accountName) {
        return this.updateAccount(accountName, DatarouterAccount::resetApiKey);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails generateSecretKey(String accountName) {
        return this.updateAccount(accountName, DatarouterAccount::resetSecretKey);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails toggleUserMappings(String accountName) {
        return this.updateAccount(accountName, DatarouterAccount::toggleUserMappings);
    }

    @BaseHandler.Handler
    public void delete(String accountName) {
        DatarouterAccountKey accountKey = new DatarouterAccountKey(accountName);
        this.datarouterAccountDao.delete(accountKey);
        DatarouterAccountPermissionKey prefix = new DatarouterAccountPermissionKey(accountName);
        this.datarouterAccountPermissionDao.deleteWithPrefix(prefix);
    }

    @BaseHandler.Handler
    public List<String> getAvailableEndpoints() {
        ArrayList<String> availableEndpoints = new ArrayList<String>();
        availableEndpoints.add("all");
        availableEndpoints.addAll(this.datarouterAccountAvailableEndpointsProvider.getAvailableEndpoints());
        return availableEndpoints;
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails addPermission(String accountName, String endpoint) {
        this.datarouterAccountPermissionDao.put(new DatarouterAccountPermission(accountName, endpoint));
        return this.getDetails(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails deletePermission(String accountName, String endpoint) {
        this.datarouterAccountPermissionDao.delete(new DatarouterAccountPermissionKey(accountName, endpoint));
        return this.getDetails(accountName);
    }

    @BaseHandler.Handler
    public boolean isServerTypeDev() {
        return StringTool.equalsCaseInsensitive((String)this.datarouterProperties.getServerTypeString(), (String)ServerType.DEV.getPersistentString());
    }

    private DatarouterAccountDetails updateAccount(String accountName, Consumer<DatarouterAccount> updateFunction) {
        DatarouterAccount account = this.datarouterAccountDao.get(new DatarouterAccountKey(accountName));
        updateFunction.accept(account);
        this.datarouterAccountDao.put(account);
        return this.getDetails(accountName);
    }

    private DatarouterAccountDetails getDetailsForAccount(DatarouterAccount account) {
        List permissions = this.datarouterAccountPermissionDao.scanKeysWithPrefix(new DatarouterAccountPermissionKey(((DatarouterAccountKey)account.getKey()).getAccountName())).map(TextPermission::create).list();
        return new DatarouterAccountDetails(account, permissions);
    }

    public static class AvailableRouteSet {
        public final String name;
        public final String className;
        public final List<String> rules;

        public AvailableRouteSet(String name, String className, List<String> rules) {
            this.name = name;
            this.className = className;
            this.rules = rules;
        }
    }

    public static class DatarouterAccountDetails {
        public final DatarouterAccount account;
        public final List<TextPermission> permissions;

        public DatarouterAccountDetails(DatarouterAccount account, List<TextPermission> permissions) {
            this.account = account;
            this.permissions = permissions;
        }
    }

    public static class TextPermission {
        public final String accountName;
        public final String endpoint;

        public TextPermission(String accountName, String endpoint) {
            this.accountName = accountName;
            this.endpoint = endpoint;
        }

        public static TextPermission create(DatarouterAccountPermissionKey permission) {
            return new TextPermission(permission.getAccountName(), permission.getEndpoint());
        }
    }
}

