/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterUserByIdCache;
import io.datarouter.auth.cache.DatarouterUserByUserTokenCache;
import io.datarouter.auth.cache.DatarouterUserByUsernameCache;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.user.session.service.SessionBasedUser;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserInfo
implements UserInfo {
    @Inject
    private DatarouterUserDao userDao;
    @Inject
    private DatarouterUserByUsernameCache datarouterUserByUsernameCache;
    @Inject
    private DatarouterUserByUserTokenCache datarouterUserByUserTokenCache;
    @Inject
    private DatarouterUserByIdCache datarouterUserByIdCache;

    @Override
    public Set<SessionBasedUser> getAllUsers(boolean enabledOnly) {
        return (Set)this.userDao.scan().include(user -> !enabledOnly || user.getEnabled() != false).collect(Collectors.toSet());
    }

    public Optional<DatarouterUser> getUserByUsername(String username) {
        if (StringTool.isEmptyOrWhitespace((String)username)) {
            return Optional.empty();
        }
        return this.datarouterUserByUsernameCache.get(username);
    }

    public Optional<DatarouterUser> getUserByToken(String token) {
        if (StringTool.isEmptyOrWhitespace((String)token)) {
            return Optional.empty();
        }
        return this.datarouterUserByUserTokenCache.get(token);
    }

    public Optional<DatarouterUser> getUserById(Long id) {
        if (id == null) {
            return Optional.empty();
        }
        return this.datarouterUserByIdCache.get(id);
    }

    private Set<Role> getRolesFromUser(Optional<? extends DatarouterUser> user) {
        return user.map(DatarouterUser::getRoles).map(HashSet::new).orElseGet(HashSet::new);
    }

    @Override
    public Set<Role> getRolesByUsername(String username) {
        return this.getRolesFromUser(this.getUserByUsername(username));
    }

    @Override
    public Set<Role> getRolesByToken(String token) {
        return this.getRolesFromUser(this.getUserByToken(token));
    }

    @Override
    public Set<Role> getRolesById(Long id) {
        return this.getRolesFromUser(this.getUserById(id));
    }
}

