/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.number.RandomTool;
import io.datarouter.web.user.authenticate.DatarouterTokenGenerator;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.util.PasswordTool;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserCreationService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserCreationService.class);
    public static final long ADMIN_ID = 1L;
    private static final Set<Role> DEFAULT_ADMIN_ROLES = Stream.of(DatarouterUserRole.DATAROUTER_ADMIN, DatarouterUserRole.ADMIN, DatarouterUserRole.USER, DatarouterUserRole.API_USER).map(DatarouterUserRole::getRole).collect(Collectors.toSet());
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterUserHistoryService userHistoryService;

    public void createFirstAdminUser(String defaultPassword) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.ADMIN, defaultPassword);
        this.populateManualFields(user, this.datarouterProperties.getAdministratorEmail(), DEFAULT_ADMIN_ROLES, true);
        this.finishCreate(user, 1L, "Automatically created admin user.");
        logger.warn("Created default admin user account");
    }

    public DatarouterUser createAutomaticUserWithoutPersist(String username, String description, Set<Role> roles) {
        return this.createAutomaticUser(username, description, roles, false);
    }

    public DatarouterUser createAutomaticUser(String username, String description) {
        return this.createAutomaticUser(username, description, Set.of(DatarouterUserRole.REQUESTOR.getRole()));
    }

    public DatarouterUser createAutomaticUser(String username, String description, Set<Role> roles) {
        return this.createAutomaticUser(username, description, roles, true);
    }

    private DatarouterUser createAutomaticUser(String username, String description, Set<Role> roles, boolean shouldPersist) {
        roles.add(DatarouterUserRole.REQUESTOR.getRole());
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.AUTO, null);
        this.populateManualFields(user, username, roles, true);
        if (shouldPersist) {
            return this.finishCreate(user, 1L, description);
        }
        return user;
    }

    public DatarouterUser createManualUser(DatarouterUser creator, String username, String password, String[] requestedRoles, boolean enabled) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.MANUAL, password);
        this.populateManualFields(user, username, this.datarouterUserService.getAllowedUserRoles(creator, requestedRoles), enabled);
        return this.finishCreate(user, creator.getId(), "User manually created by " + creator.getUsername());
    }

    private void populateGeneratedFields(DatarouterUser user, CreateType type, String password) {
        ((DatarouterUserKey)user.getKey()).setId(Long.valueOf(type == CreateType.ADMIN ? 1L : RandomTool.nextPositiveLong()));
        user.setUserToken(DatarouterTokenGenerator.generateRandomToken());
        user.setCreated(new Date());
        user.setLastLoggedIn(type == CreateType.ADMIN ? user.getCreated() : null);
        user.setPasswordSalt(type == CreateType.AUTO ? null : PasswordTool.generateSalt());
        user.setPasswordDigest(type == CreateType.AUTO ? null : PasswordTool.digest((String)user.getPasswordSalt(), (String)password));
    }

    private void populateManualFields(DatarouterUser user, String username, Set<Role> roles, Boolean enabled) {
        user.setUsername(username);
        user.setRoles(roles);
        user.setEnabled(enabled);
    }

    private DatarouterUser finishCreate(DatarouterUser user, Long editorId, String description) {
        this.datarouterUserService.assertUserDoesNotExist(user.getId(), user.getUserToken(), user.getUsername());
        this.userHistoryService.recordCreate(user, editorId, description);
        return user;
    }

    private static enum CreateType {
        ADMIN,
        AUTO,
        MANUAL;

    }
}

