/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.util;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordTool {
    private static final Logger logger = LoggerFactory.getLogger(PasswordTool.class);
    private static final int NUM_DIGEST_ITERATIONS = 2471;
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final SecureRandom SECURE_RANDOM = PasswordTool.initRandom();

    private static SecureRandom initRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digest(String salt, String rawPassword) {
        Object sr = salt + rawPassword;
        int i = 0;
        while (i < 2471) {
            sr = DigestUtils.sha256Hex((String)sr);
            ++i;
        }
        return sr;
    }

    public static String generateSalt() {
        byte[] salt = new byte[16];
        long start = System.nanoTime();
        SECURE_RANDOM.nextBytes(salt);
        long durationNs = System.nanoTime() - start;
        if (durationNs > 1000000L) {
            logger.warn("slow random number generation durationNs={}", (Object)durationNs);
        }
        return BASE64_ENCODER.encodeToString(salt);
    }
}

