/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.util;

import io.datarouter.scanner.Scanner;
import io.datarouter.util.number.NumberTool;
import io.datarouter.util.string.StringTool;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieTool {
    public static void addCookie(HttpServletResponse response, String cookieName, String value, String path, int maxAgeSeconds) {
        Cookie cookie = new Cookie(cookieName, value);
        if (path != null) {
            cookie.setPath(path);
        }
        cookie.setMaxAge(maxAgeSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String cookieName, String value, String path, long maxAgeSeconds) {
        CookieTool.addCookie(response, cookieName, value, path, maxAgeSeconds, false);
    }

    public static void addCookie(HttpServletResponse response, String cookieName, String value, String path, long maxAgeSeconds, boolean sameSiteNone) {
        if (sameSiteNone) {
            CookieTool.addCookieSameSiteNone(response, cookieName, value, path, maxAgeSeconds);
        } else {
            CookieTool.addCookie(response, cookieName, value, path, NumberTool.limitLongToIntRange((long)maxAgeSeconds));
        }
    }

    public static void addCookieSameSiteNone(HttpServletResponse response, String cookieName, String value, String path, long maxAgeSeconds) {
        String cookie = String.join((CharSequence)"; ", cookieName + "=" + value, "Path=" + path, "Max-Age=" + NumberTool.limitLongToIntRange((long)maxAgeSeconds), "HttpOnly", "SameSite=None", "Secure");
        response.addHeader("Set-Cookie", cookie);
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = CookieTool.getCookie(request.getCookies(), cookieName);
        return cookie == null ? null : cookie.getValue();
    }

    public static String getCookieValue(Cookie[] cookies, String cookieName, String defaultValue) {
        Cookie cookie = CookieTool.getCookie(cookies, cookieName);
        if (cookie == null) {
            return defaultValue;
        }
        return cookie.getValue();
    }

    public static Boolean getCookieBoolean(Cookie[] cookies, String cookieName) {
        String value = CookieTool.getCookieValue(cookies, cookieName, null);
        if (value == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Boolean getCookieBooleanDefault(Cookie[] cookies, String cookieName, Boolean defaultValue) {
        String value = CookieTool.getCookieValue(cookies, cookieName, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String escapeCookieCharacters(String value) {
        value = value.replace("%", "%25");
        value = value.replace(" ", "%20");
        value = value.replace(",", "%2C");
        value = value.replace(";", "%3B");
        value = value.replace("=", "%3D");
        return value;
    }

    public static String unescapeCookieCharacters(String value) {
        value = value.replace("%3B", ";");
        value = value.replace("%2C", ",");
        value = value.replace("%20", " ");
        value = value.replace("%25", "%");
        value = value.replace("%3D", "=");
        return value;
    }

    public static Cookie getCookie(Cookie[] cookies, String cookieName) {
        if (cookies != null && cookieName != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    return cookie;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Optional<String> getFormattedCookie(Cookie[] cookies, String cookieName, String regex, String replacement) {
        return Scanner.of((Object[])cookies).include(cookie -> cookieName.equals(cookie.getName())).map(Cookie::getValue).map(value -> value.replaceFirst(regex, replacement)).map(value -> URLDecoder.decode(value, StandardCharsets.UTF_8)).findFirst();
    }

    public static void deleteCookie(HttpServletResponse response, String cookieName) {
        Cookie cookieToKill = new Cookie(cookieName, "");
        cookieToKill.setPath("/");
        cookieToKill.setMaxAge(0);
        response.addCookie(cookieToKill);
    }

    public static Map<String, String> getMapFromString(String string, String entrySeperator, String keyValueSeparator) {
        String[] entries;
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (StringTool.isEmpty((String)string)) {
            return map;
        }
        String[] stringArray = entries = string.split(entrySeperator);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (StringTool.notEmpty((String)entry)) {
                String[] keyVal = entry.split(keyValueSeparator);
                map.put(keyVal[0], keyVal.length > 1 ? keyVal[1] : null);
            }
            ++n2;
        }
        return map;
    }
}

