/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user.session;

import io.datarouter.auth.authenticate.DatarouterTokenGenerator;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.auth.session.Session;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserKey;
import io.datarouter.auth.storage.user.session.BaseDatarouterSessionDatabean;
import io.datarouter.auth.storage.user.session.DatarouterSessionKey;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.MilliTimeFieldCodec;
import io.datarouter.model.field.codec.StringListToBinaryCsvFieldCodec;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.array.ByteArrayEncodedField;
import io.datarouter.model.field.imp.array.ByteArrayEncodedFieldKey;
import io.datarouter.model.field.imp.comparable.LongEncodedField;
import io.datarouter.model.field.imp.comparable.LongEncodedFieldKey;
import io.datarouter.model.field.imp.comparable.LongField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.scanner.IterableScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.types.MilliTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class DatarouterSession
extends BaseDatarouterSessionDatabean<DatarouterSessionKey, DatarouterSession>
implements Session {
    private Long userId;
    private String userToken;
    private String username;
    private MilliTime userCreatedAt;
    private List<String> roles;
    private Boolean persistent = true;

    public Supplier<DatarouterSessionKey> getKeySupplier() {
        return DatarouterSessionKey::new;
    }

    public DatarouterSession() {
        super(new DatarouterSessionKey(null));
    }

    public static DatarouterSession createAnonymousSession(String userToken) {
        DatarouterSession session = new DatarouterSession();
        session.setUserToken(userToken);
        ((DatarouterSessionKey)session.getKey()).setSessionToken(DatarouterTokenGenerator.generateRandomToken());
        MilliTime now = MilliTime.now();
        session.setCreated(now.toDate());
        session.setUpdated(now.toDate());
        session.setRoles(Collections.emptyList());
        return session;
    }

    public static DatarouterSession createFromUser(DatarouterUser user) {
        DatarouterSession session = DatarouterSession.createAnonymousSession(user.getUserToken());
        session.setUserId(user.getId());
        session.setUserCreated(user.getCreated());
        session.setUsername(user.getUsername());
        session.setRoles(user.getRolesIgnoreSaml());
        return session;
    }

    public static DatarouterSession nullSafe(DatarouterSession in) {
        return in == null ? new DatarouterSession() : in;
    }

    public static boolean equals(DatarouterSession first, DatarouterSession second) {
        return first.equals(second) && Objects.equals(first.getUserId(), second.getUserId()) && Objects.equals(first.getUserToken(), second.getUserToken()) && Objects.equals(first.getUsername(), second.getUsername()) && Objects.equals(first.getUserCreated(), second.getUserCreated()) && Objects.equals(first.getRoles(), second.getRoles()) && Objects.equals(first.getPersistent(), second.getPersistent()) && Objects.equals(first.getCreated(), second.getCreated()) && Objects.equals(first.getUpdated(), second.getUpdated());
    }

    public DatarouterUserKey getUserKey() {
        if (this.userId == null) {
            return null;
        }
        return new DatarouterUserKey(this.userId);
    }

    public Collection<Role> getRoles() {
        return IterableScanner.ofNullable(this.roles).map(Role::new).list();
    }

    public void setRoles(Collection<Role> roles) {
        this.roles = Scanner.of(roles).map(Role::getPersistentString).sort().distinct().list();
    }

    public boolean isAnonymous() {
        return this.roles == null || this.roles.isEmpty();
    }

    public boolean hasRole(Role role) {
        return this.roles.contains(role.getPersistentString());
    }

    public boolean hasRole(RoleEnum<?> role) {
        return this.hasRole(role.getRole());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getId() {
        return this.userId;
    }

    public void setId(Long id) {
        this.userId = id;
    }

    @Override
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public MilliTime getUserCreated() {
        return this.userCreatedAt;
    }

    public void setUserCreated(MilliTime userCreated) {
        this.userCreatedAt = userCreated;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public String getSessionToken() {
        return ((DatarouterSessionKey)this.getKey()).getSessionToken();
    }

    public static class DatarouterSessionFielder
    extends BaseDatabeanFielder<DatarouterSessionKey, DatarouterSession> {
        public DatarouterSessionFielder() {
            super(DatarouterSessionKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterSession databean) {
            ArrayList nonKeyFields = new ArrayList(databean.getNonKeyFields());
            nonKeyFields.add((Field<?>)new LongField(FieldKeys.userId, databean.userId));
            nonKeyFields.add((Field<?>)new StringField(FieldKeys.userToken, databean.userToken));
            nonKeyFields.add((Field<?>)new StringField(FieldKeys.username, databean.username));
            nonKeyFields.add((Field<?>)new ByteArrayEncodedField(FieldKeys.roles, databean.roles));
            nonKeyFields.add((Field<?>)new LongEncodedField(FieldKeys.userCreatedAt, (Object)databean.userCreatedAt));
            return nonKeyFields;
        }
    }

    public static class FieldKeys {
        public static final LongFieldKey userId = new LongFieldKey("userId");
        public static final StringFieldKey userToken = new StringFieldKey("userToken");
        public static final StringFieldKey username = new StringFieldKey("username");
        public static final ByteArrayEncodedFieldKey<List<String>> roles = new ByteArrayEncodedFieldKey("roles", StringListToBinaryCsvFieldCodec.INSTANCE).withSize(0xFFFFFF);
        public static final LongEncodedFieldKey<MilliTime> userCreatedAt = new LongEncodedFieldKey("userCreatedAt", (FieldCodec)new MilliTimeFieldCodec());
    }
}

