/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user.saml;

import io.datarouter.auth.storage.user.saml.BaseDatarouterSamlDao;
import io.datarouter.auth.storage.user.saml.SamlAuthnRequestRedirectUrl;
import io.datarouter.auth.storage.user.saml.SamlAuthnRequestRedirectUrlKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.storage.vacuum.DatabeanVacuum;
import io.datarouter.types.MilliTime;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterSamlDao
extends BaseDao
implements BaseDatarouterSamlDao {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterSamlDao.class);
    private final SortedMapStorage.SortedMapStorageNode<SamlAuthnRequestRedirectUrlKey, SamlAuthnRequestRedirectUrl, SamlAuthnRequestRedirectUrl.SamlAuthnRequestRedirectUrlFielder> node;

    @Inject
    public DatarouterSamlDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterSamlDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of(params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, SamlAuthnRequestRedirectUrl::new, SamlAuthnRequestRedirectUrl.SamlAuthnRequestRedirectUrlFielder::new).withTag(Tag.DATAROUTER).disableNodewatchPercentageAlert().build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    @Override
    public void put(SamlAuthnRequestRedirectUrl databean) {
        this.node.put((Databean)databean);
    }

    @Override
    public SamlAuthnRequestRedirectUrl get(SamlAuthnRequestRedirectUrlKey key) {
        return (SamlAuthnRequestRedirectUrl)this.node.get((PrimaryKey)key);
    }

    public DatabeanVacuum<SamlAuthnRequestRedirectUrlKey, SamlAuthnRequestRedirectUrl> makeVacuum() {
        MilliTime deleteBefore = MilliTime.now().minus(Duration.ofSeconds(5L));
        return new DatabeanVacuum.DatabeanVacuumBuilder(this.node.scan(), databean -> {
            boolean willDelete = databean.getCreated().isBefore(deleteBefore);
            if (willDelete) {
                logger.warn("will delete old SamlAuthnRequestRedirectUrl authnRequestId={} created={} url={}", new Object[]{((SamlAuthnRequestRedirectUrlKey)databean.getKey()).getAuthnRequestId(), databean.getCreated(), databean.getRedirectUrl()});
            }
            return willDelete;
        }, arg_0 -> this.node.deleteMulti(arg_0)).build();
    }

    public record DatarouterSamlDaoParams(List<ClientId> clientIds) {
    }
}

