/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user.permissionrequest;

import io.datarouter.auth.storage.user.permissionrequest.PermissionRequestKey;
import io.datarouter.auth.storage.user.userhistory.DatarouterUserHistoryLog;
import io.datarouter.auth.storage.user.userhistory.DatarouterUserHistoryLogKey;
import io.datarouter.enums.StringMappedEnum;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.MilliTimeFieldCodec;
import io.datarouter.model.field.codec.StringMappedEnumFieldCodec;
import io.datarouter.model.field.imp.StringEncodedField;
import io.datarouter.model.field.imp.StringEncodedFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.LongEncodedField;
import io.datarouter.model.field.imp.comparable.LongEncodedFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.types.BaseMilliTime;
import io.datarouter.types.MilliTime;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class PermissionRequest
extends BaseDatabean<PermissionRequestKey, PermissionRequest> {
    private String requestText;
    private DatarouterPermissionRequestResolution resolution;
    private MilliTime resolutionTime;
    public static final Comparator<PermissionRequest> REVERSE_CHRONOLOGICAL_COMPARATOR = Comparator.comparing(request -> ((PermissionRequestKey)request.getKey()).getRequestTime(), Comparator.reverseOrder());

    public PermissionRequest() {
        super((PrimaryKey)new PermissionRequestKey());
    }

    public PermissionRequest(Long userId, MilliTime requestTime, String requestText, DatarouterPermissionRequestResolution resolution, MilliTime resolutionTime) {
        super((PrimaryKey)new PermissionRequestKey(userId, requestTime));
        this.requestText = requestText;
        this.resolution = resolution;
        this.resolutionTime = resolutionTime;
    }

    public Optional<DatarouterUserHistoryLogKey> toUserHistoryKey() {
        return Optional.ofNullable(this.resolutionTime).map(time -> new DatarouterUserHistoryLogKey(((PermissionRequestKey)this.getKey()).getUserId(), (MilliTime)time));
    }

    private PermissionRequest resolve(DatarouterPermissionRequestResolution resolution, Optional<Instant> resolutionTime) {
        this.setResolution(resolution);
        this.setResolutionTime(resolutionTime.orElse(null));
        return this;
    }

    public PermissionRequest changeUser(DatarouterUserHistoryLog change) {
        return this.resolve(DatarouterPermissionRequestResolution.USER_CHANGED, Optional.of(((DatarouterUserHistoryLogKey)change.getKey()).getTime()));
    }

    public PermissionRequest supercede() {
        return this.resolve(DatarouterPermissionRequestResolution.SUPERCEDED, Optional.of(Instant.now()));
    }

    public PermissionRequest expire() {
        return this.resolve(DatarouterPermissionRequestResolution.EXPIRED, Optional.ofNullable(Instant.now()));
    }

    public PermissionRequest decline(Instant time) {
        return this.resolve(DatarouterPermissionRequestResolution.DECLINED, Optional.ofNullable(time));
    }

    public Supplier<PermissionRequestKey> getKeySupplier() {
        return PermissionRequestKey::new;
    }

    public String getRequestText() {
        return this.requestText;
    }

    public void setRequestText(String requestText) {
        this.requestText = requestText;
    }

    public DatarouterPermissionRequestResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(DatarouterPermissionRequestResolution resolution) {
        this.resolution = resolution;
    }

    public Optional<Instant> getResolutionTime() {
        return Optional.ofNullable(this.resolutionTime).map(BaseMilliTime::toInstant);
    }

    public void setResolutionTime(Instant resolutionTime) {
        this.resolutionTime = MilliTime.of((Instant)resolutionTime);
    }

    public static enum DatarouterPermissionRequestResolution {
        SUPERCEDED("superceded"),
        USER_CHANGED("changed"),
        DECLINED("declined"),
        EXPIRED("expired");

        public static final StringMappedEnum<DatarouterPermissionRequestResolution> BY_PERSISTENT_STRING;
        public final String persistentString;

        static {
            BY_PERSISTENT_STRING = new StringMappedEnum((Object[])DatarouterPermissionRequestResolution.values(), value -> value.persistentString);
        }

        private DatarouterPermissionRequestResolution(String persistentString) {
            this.persistentString = persistentString;
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey requestText = new StringFieldKey("requestText").withSize(65535);
        public static final StringEncodedFieldKey<DatarouterPermissionRequestResolution> resolution = new StringEncodedFieldKey("resolution", (FieldCodec)new StringMappedEnumFieldCodec(DatarouterPermissionRequestResolution.BY_PERSISTENT_STRING));
        public static final LongEncodedFieldKey<MilliTime> resolutionTime = new LongEncodedFieldKey("resolutionTime", (FieldCodec)new MilliTimeFieldCodec());
    }

    public static class PermissionRequestFielder
    extends BaseDatabeanFielder<PermissionRequestKey, PermissionRequest> {
        public PermissionRequestFielder() {
            super(PermissionRequestKey::new);
        }

        public List<Field<?>> getNonKeyFields(PermissionRequest databean) {
            return List.of(new StringField(FieldKeys.requestText, databean.requestText), new StringEncodedField(FieldKeys.resolution, (Object)databean.resolution), new LongEncodedField(FieldKeys.resolutionTime, (Object)databean.resolutionTime));
        }
    }
}

