/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user.permissionrequest;

import io.datarouter.auth.storage.user.permissionrequest.PermissionRequest;
import io.datarouter.auth.storage.user.permissionrequest.PermissionRequestKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.types.MilliTime;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Singleton
public class DatarouterPermissionRequestDao
extends BaseDao {
    private final SortedMapStorage.SortedMapStorageNode<PermissionRequestKey, PermissionRequest, PermissionRequest.PermissionRequestFielder> node;

    @Inject
    public DatarouterPermissionRequestDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterPermissionRequestDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of(params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, PermissionRequest::new, PermissionRequest.PermissionRequestFielder::new).withTag(Tag.DATAROUTER).build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void putMulti(Collection<PermissionRequest> databeans) {
        this.node.putMulti(databeans);
    }

    public Scanner<PermissionRequest> scan() {
        return this.node.scan();
    }

    public Scanner<PermissionRequest> scanWithPrefix(PermissionRequestKey prefix) {
        return this.node.scanWithPrefix((PrimaryKey)prefix);
    }

    public Scanner<PermissionRequest> scanOpenPermissionRequests() {
        return this.scan().include(request -> request.getResolution() == null);
    }

    public Scanner<PermissionRequest> scanOpenPermissionRequestsForUser(Long userId) {
        Objects.requireNonNull(userId);
        return this.scanOpenPermissionRequestsForUsers(List.of(userId));
    }

    public Scanner<PermissionRequest> scanOpenPermissionRequestsForUsers(List<Long> userIds) {
        return ((Scanner)Scanner.of(userIds).map(userId -> new PermissionRequestKey((Long)userId, null)).listTo(arg_0 -> this.node.scanWithPrefixes(arg_0))).include(request -> request.getResolution() == null);
    }

    public Scanner<PermissionRequest> scanPermissionRequestsForUser(Long userId) {
        return this.scanWithPrefix(new PermissionRequestKey(userId, null));
    }

    public void createPermissionRequest(PermissionRequest request) {
        this.scanOpenPermissionRequestsForUser(((PermissionRequestKey)request.getKey()).getUserId()).map(PermissionRequest::supercede).append((Object[])new PermissionRequest[]{request}).flush(this::putMulti);
    }

    public void expireAll(Long userId) {
        this.scanOpenPermissionRequestsForUser(userId).map(PermissionRequest::expire).flush(this::putMulti);
    }

    public void declineAll(Long userId, MilliTime declineTime) {
        this.scanOpenPermissionRequestsForUser(userId).map(request -> request.decline(declineTime.toInstant())).flush(this::putMulti);
    }

    public Set<Long> getUserIdsWithPermissionRequests() {
        return (Set)this.scanOpenPermissionRequests().map(BaseDatabean::getKey).map(PermissionRequestKey::getUserId).collect(HashSet::new);
    }

    public record DatarouterPermissionRequestDaoParams(List<ClientId> clientIds) {
    }
}

