/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user.deprovisioneduser;

import io.datarouter.auth.model.dto.DeprovisionedUserDto;
import io.datarouter.auth.model.dto.UserDeprovisioningStatusDto;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.storage.user.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.enums.StringMappedEnum;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.StringListToBinaryCsvFieldCodec;
import io.datarouter.model.field.codec.StringMappedEnumFieldCodec;
import io.datarouter.model.field.imp.StringEncodedField;
import io.datarouter.model.field.imp.StringEncodedFieldKey;
import io.datarouter.model.field.imp.array.ByteArrayEncodedField;
import io.datarouter.model.field.imp.array.ByteArrayEncodedFieldKey;
import io.datarouter.model.field.imp.comparable.InstantField;
import io.datarouter.model.field.imp.comparable.InstantFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.scanner.Scanner;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class DeprovisionedUser
extends BaseDatabean<DeprovisionedUserKey, DeprovisionedUser> {
    private List<String> roles;
    private UserDeprovisioningStatus status;
    private Instant updated;

    public DeprovisionedUser() {
        super((PrimaryKey)new DeprovisionedUserKey(null));
    }

    public DeprovisionedUser(String username, Collection<Role> roles, UserDeprovisioningStatus status) {
        super((PrimaryKey)new DeprovisionedUserKey(username));
        this.setRoles(roles);
        this.status = status;
        this.updated = Instant.now();
    }

    public DeprovisionedUserDto toDto() {
        return new DeprovisionedUserDto(this.getUsername(), Scanner.of(this.roles).sort(String.CASE_INSENSITIVE_ORDER).list(), this.status.dto);
    }

    public Supplier<DeprovisionedUserKey> getKeySupplier() {
        return DeprovisionedUserKey::new;
    }

    public String getUsername() {
        return ((DeprovisionedUserKey)this.getKey()).getUsername();
    }

    public Set<Role> getRoles() {
        return (Set)Scanner.of(this.roles).map(Role::new).collect(HashSet::new);
    }

    public void setRoles(Collection<Role> roles) {
        this.roles = Scanner.of(roles).map(Role::getPersistentString).sort().distinct().list();
    }

    public UserDeprovisioningStatus getStatus() {
        return this.status;
    }

    public Instant getUpdated() {
        return this.updated;
    }

    public static class DeprovisionedUserFielder
    extends BaseDatabeanFielder<DeprovisionedUserKey, DeprovisionedUser> {
        public DeprovisionedUserFielder() {
            super(DeprovisionedUserKey::new);
        }

        public List<Field<?>> getNonKeyFields(DeprovisionedUser user) {
            return List.of(new ByteArrayEncodedField(FieldKeys.roles, user.roles), new StringEncodedField(FieldKeys.status, (Object)user.status), new InstantField(FieldKeys.updated, user.updated));
        }
    }

    public static class FieldKeys {
        public static final ByteArrayEncodedFieldKey<List<String>> roles = new ByteArrayEncodedFieldKey("roles", StringListToBinaryCsvFieldCodec.INSTANCE).withSize(0xFFFFFF);
        public static final StringEncodedFieldKey<UserDeprovisioningStatus> status = new StringEncodedFieldKey("status", (FieldCodec)new StringMappedEnumFieldCodec(UserDeprovisioningStatus.BY_PERSISTENT_STRING));
        public static final InstantFieldKey updated = new InstantFieldKey("updated");
    }

    public static enum UserDeprovisioningStatus {
        DEPROVISIONED("deprovisioned", UserDeprovisioningStatusDto.DEPROVISIONED),
        FLAGGED("flagged", UserDeprovisioningStatusDto.FLAGGED);

        public static final StringMappedEnum<UserDeprovisioningStatus> BY_PERSISTENT_STRING;
        private final String persistentString;
        private final UserDeprovisioningStatusDto dto;

        static {
            BY_PERSISTENT_STRING = new StringMappedEnum((Object[])UserDeprovisioningStatus.values(), value -> value.persistentString);
        }

        private UserDeprovisioningStatus(String persistentString, UserDeprovisioningStatusDto dto) {
            this.persistentString = persistentString;
            this.dto = dto;
        }
    }
}

