/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account.credential.secret;

import io.datarouter.auth.storage.account.credential.secret.BaseDatarouterAccountSecretCredentialDao;
import io.datarouter.auth.storage.account.credential.secret.DatarouterAccountSecretCredential;
import io.datarouter.auth.storage.account.credential.secret.DatarouterAccountSecretCredentialKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.PutMethod;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.node.builder.NodeBuilder;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Singleton
public class DatarouterAccountSecretCredentialDao
extends BaseDao
implements BaseDatarouterAccountSecretCredentialDao {
    private final SortedMapStorage.SortedMapStorageNode<DatarouterAccountSecretCredentialKey, DatarouterAccountSecretCredential, DatarouterAccountSecretCredential.DatarouterAccountSecretCredentialFielder> node;

    @Inject
    public DatarouterAccountSecretCredentialDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterAccountSecretCredentialDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of(params.clientIds).map(clientId -> {
            NodeBuilder builder = nodeFactory.create(clientId, DatarouterAccountSecretCredential::new, DatarouterAccountSecretCredential.DatarouterAccountSecretCredentialFielder::new).withTag(Tag.DATAROUTER).withTableName(datarouterAccountSecretCredentialDaoParams.tableName);
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)builder.build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    @Override
    public void insertOrBust(DatarouterAccountSecretCredential databean) {
        this.node.put((Databean)databean, new Config().setPutMethod(PutMethod.INSERT_OR_BUST));
    }

    @Override
    public void updateIgnore(DatarouterAccountSecretCredential databean) {
        this.node.put((Databean)databean, new Config().setPutMethod(PutMethod.UPDATE_IGNORE));
    }

    @Override
    public void updateMultiIgnore(Collection<DatarouterAccountSecretCredential> databeans) {
        this.node.putMulti(databeans, new Config().setPutMethod(PutMethod.UPDATE_IGNORE));
    }

    @Override
    public DatarouterAccountSecretCredential get(DatarouterAccountSecretCredentialKey key) {
        return (DatarouterAccountSecretCredential)this.node.get((PrimaryKey)key);
    }

    @Override
    public Scanner<DatarouterAccountSecretCredential> scan() {
        return this.node.scan();
    }

    @Override
    public Scanner<DatarouterAccountSecretCredential> scanMulti(Collection<DatarouterAccountSecretCredentialKey> keys) {
        return this.node.scanMulti(keys);
    }

    @Override
    public void delete(DatarouterAccountSecretCredentialKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public static class DatarouterAccountSecretCredentialDaoParams {
        public final List<ClientId> clientIds;
        public final Optional<String> tableName;

        public DatarouterAccountSecretCredentialDaoParams(List<ClientId> clientIds) {
            this.clientIds = clientIds;
            this.tableName = Optional.empty();
        }

        public DatarouterAccountSecretCredentialDaoParams(List<ClientId> clientIds, String tableName) {
            this.clientIds = clientIds;
            Require.isTrue((boolean)StringTool.notNullNorEmpty((String)tableName));
            this.tableName = Optional.of(tableName);
        }
    }
}

