/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account.credential;

import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.credential.DatarouterAccountCredentialKey;
import io.datarouter.auth.util.PasswordTool;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.field.imp.comparable.LongEncodedField;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.types.MilliTime;
import io.datarouter.util.time.ZonedDateFormatterTool;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.function.Supplier;

public class DatarouterAccountCredential
extends BaseDatabean<DatarouterAccountCredentialKey, DatarouterAccountCredential> {
    private String accountName;
    private String secretKey;
    private MilliTime createdAt;
    private String creatorUsername;
    private MilliTime lastUsedAt;
    private Boolean active;

    public DatarouterAccountCredential() {
        super((PrimaryKey)new DatarouterAccountCredentialKey());
    }

    public DatarouterAccountCredential(String apiKey, String secretKey, String accountName, String creatorUsername) {
        super((PrimaryKey)new DatarouterAccountCredentialKey(apiKey));
        this.secretKey = secretKey;
        this.accountName = accountName;
        this.createdAt = MilliTime.now();
        this.creatorUsername = creatorUsername;
        this.active = true;
    }

    public static DatarouterAccountCredential create(String accountName, String creatorUsername) {
        return new DatarouterAccountCredential(PasswordTool.generateSalt(), PasswordTool.generateSalt(), accountName, creatorUsername);
    }

    public Supplier<DatarouterAccountCredentialKey> getKeySupplier() {
        return DatarouterAccountCredentialKey::new;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCreatedDate(ZoneId zoneId) {
        return ZonedDateFormatterTool.formatInstantWithZone((Instant)this.getCreatedInstant(), (ZoneId)zoneId);
    }

    public Instant getCreatedInstant() {
        if (this.createdAt == null) {
            return Instant.EPOCH;
        }
        return this.createdAt.toInstant();
    }

    public String getCreatorUsername() {
        return this.creatorUsername;
    }

    public void setLastUsed(MilliTime lastUsedAt) {
        this.lastUsedAt = lastUsedAt;
    }

    public String getLastUsedDate(ZoneId zoneId) {
        return ZonedDateFormatterTool.formatInstantWithZone((Instant)this.getLastUsedInstant(), (ZoneId)zoneId);
    }

    public Instant getLastUsedInstant() {
        if (this.lastUsedAt == null) {
            return Instant.EPOCH;
        }
        return this.lastUsedAt.toInstant();
    }

    public Boolean getActive() {
        if (this.active != null && !this.active.booleanValue()) {
            return false;
        }
        return true;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public static class DatarouterAccountCredentialFielder
    extends BaseDatabeanFielder<DatarouterAccountCredentialKey, DatarouterAccountCredential> {
        public DatarouterAccountCredentialFielder() {
            super(DatarouterAccountCredentialKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterAccountCredential credential) {
            return List.of(new StringField(FieldKeys.accountName, credential.accountName), new StringField(FieldKeys.secretKey, credential.secretKey), new LongEncodedField(DatarouterAccount.FieldKeys.createdAt, (Object)credential.createdAt), new StringField(FieldKeys.creatorUsername, credential.creatorUsername), new LongEncodedField(DatarouterAccount.FieldKeys.lastUsedAt, (Object)credential.lastUsedAt), new BooleanField(FieldKeys.active, credential.active));
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey accountName = new StringFieldKey("accountName");
        private static final StringFieldKey secretKey = new StringFieldKey("secretKey");
        private static final StringFieldKey creatorUsername = new StringFieldKey("creatorUsername");
        private static final BooleanFieldKey active = new BooleanFieldKey("active");
    }
}

