/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.MilliTimeFieldCodec;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.field.imp.comparable.LongEncodedField;
import io.datarouter.model.field.imp.comparable.LongEncodedFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.types.MilliTime;
import io.datarouter.util.string.StringTool;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.function.Supplier;

public class DatarouterAccount
extends BaseDatabean<DatarouterAccountKey, DatarouterAccount> {
    private MilliTime createdAt;
    private String creator;
    private MilliTime lastUsedAt;
    private Boolean enableUserMappings;
    public String callerType;
    public String referer;

    public DatarouterAccount() {
        super((PrimaryKey)new DatarouterAccountKey());
    }

    public DatarouterAccount(String accountName, MilliTime createdAt, String creator) {
        super((PrimaryKey)new DatarouterAccountKey(accountName));
        this.createdAt = createdAt;
        this.creator = creator;
        this.enableUserMappings = false;
        this.callerType = null;
        this.referer = null;
    }

    public DatarouterAccount(String accountName, DatarouterAccount account) {
        this(accountName, account.getCreated(), account.getCreator());
        this.enableUserMappings = account.getEnableUserMappings();
        this.lastUsedAt = account.getLastUsed();
        this.callerType = account.getCallerType();
        this.referer = account.getReferrer();
    }

    public Supplier<DatarouterAccountKey> getKeySupplier() {
        return DatarouterAccountKey::new;
    }

    public String getCreatedDate(ZoneId zoneId) {
        if (this.createdAt == null) {
            return "";
        }
        return this.createdAt.format(zoneId);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setLastUsed(MilliTime lastUsedAt) {
        this.lastUsedAt = lastUsedAt;
    }

    public String getLastUsedDate(ZoneId zoneId) {
        if (this.lastUsedAt == null) {
            return "";
        }
        return this.lastUsedAt.format(zoneId);
    }

    public MilliTime getLastUsed() {
        return this.lastUsedAt;
    }

    public Instant getLastUsedInstant() {
        if (this.lastUsedAt == null) {
            return Instant.MIN;
        }
        return this.lastUsedAt.toInstant();
    }

    public void toggleUserMappings() {
        this.enableUserMappings = this.enableUserMappings == null ? Boolean.valueOf(true) : Boolean.valueOf(this.enableUserMappings == false);
    }

    public boolean getEnableUserMappings() {
        if (this.enableUserMappings == null) {
            return false;
        }
        return this.enableUserMappings;
    }

    public void setEnableUserMappings(boolean enableUserMappings) {
        this.enableUserMappings = enableUserMappings;
    }

    public MilliTime getCreated() {
        return this.createdAt;
    }

    public void setCallerType(String callerType) {
        this.callerType = callerType;
    }

    public String getCallerType() {
        return this.callerType;
    }

    public String getReferrer() {
        return this.referer;
    }

    public void setReferrer(String referrer) {
        this.referer = StringTool.isEmptyOrWhitespace((String)referrer) ? null : referrer.trim();
    }

    public static class DatarouterAccountFielder
    extends BaseDatabeanFielder<DatarouterAccountKey, DatarouterAccount> {
        public DatarouterAccountFielder() {
            super(DatarouterAccountKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterAccount account) {
            return List.of(new LongEncodedField(FieldKeys.createdAt, (Object)account.createdAt), new StringField(FieldKeys.creator, account.creator), new LongEncodedField(FieldKeys.lastUsedAt, (Object)account.lastUsedAt), new BooleanField(FieldKeys.enableUserMappings, account.enableUserMappings), new StringField(FieldKeys.callerType, account.callerType), new StringField(FieldKeys.referer, account.referer));
        }
    }

    public static class FieldKeys {
        public static final LongEncodedFieldKey<MilliTime> createdAt = new LongEncodedFieldKey("createdAt", (FieldCodec)new MilliTimeFieldCodec());
        public static final StringFieldKey creator = new StringFieldKey("creator");
        public static final LongEncodedFieldKey<MilliTime> lastUsedAt = new LongEncodedFieldKey("lastUsedAt", (FieldCodec)new MilliTimeFieldCodec());
        public static final BooleanFieldKey enableUserMappings = new BooleanFieldKey("enableUserMappings");
        public static final StringFieldKey callerType = new StringFieldKey("callerType");
        public static final StringFieldKey referrer = new StringFieldKey("referrer");
        public static final StringFieldKey referer = new StringFieldKey("referer");
    }
}

