/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.session;

import io.datarouter.auth.model.dto.InterpretedSamlAssertion;
import io.datarouter.auth.session.Session;
import io.datarouter.auth.session.SessionBasedUser;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface UserSessionService {
    public void setSessionCookies(HttpServletResponse var1, Session var2);

    public void clearSessionCookies(HttpServletResponse var1);

    public SessionBasedUser createAuthorizedUser(String var1, String var2);

    public Session signInUserFromSamlResponse(HttpServletRequest var1, InterpretedSamlAssertion var2);

    public void deleteSession(HttpServletRequest var1);

    public void deleteUserSessions(List<String> var1);

    public Optional<ZoneId> getZoneId(String var1);

    public static class NoOpUserSessionService
    implements UserSessionService {
        @Override
        public void setSessionCookies(HttpServletResponse response, Session session) {
        }

        @Override
        public void clearSessionCookies(HttpServletResponse response) {
        }

        @Override
        public SessionBasedUser createAuthorizedUser(String username, String description) {
            return null;
        }

        @Override
        public Session signInUserFromSamlResponse(HttpServletRequest request, InterpretedSamlAssertion interpretedSamlAssertion) {
            return null;
        }

        @Override
        public void deleteSession(HttpServletRequest request) {
        }

        @Override
        public void deleteUserSessions(List<String> usernames) {
        }

        @Override
        public Optional<ZoneId> getZoneId(String username) {
            return Optional.empty();
        }
    }
}

