/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.session;

import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.auth.session.CurrentSessionInfo;
import io.datarouter.auth.session.Session;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletRequest;

@Singleton
public class RequestAwareCurrentSessionInfoFactory {
    @Inject
    private CurrentSessionInfo currentSessionInfo;

    public RequestAwareCurrentSessionInfo build(ServletRequest request) {
        return new RequestAwareCurrentSessionInfo(this.currentSessionInfo, request);
    }

    public static class RequestAwareCurrentSessionInfo {
        private final CurrentSessionInfo currentSessionInfo;
        private final ServletRequest request;

        public RequestAwareCurrentSessionInfo(CurrentSessionInfo currentSessionInfo, ServletRequest request) {
            this.currentSessionInfo = currentSessionInfo;
            this.request = request;
        }

        public Optional<String> findNonEmptyUsername() {
            return this.currentSessionInfo.findNonEmptyUsername(this.request);
        }

        public String getNonEmptyUsernameOrElse(String other) {
            return this.currentSessionInfo.getNonEmptyUsernameOrElse(this.request, other);
        }

        public Optional<? extends Session> getSession() {
            return this.currentSessionInfo.getSession(this.request);
        }

        public Session getRequiredSession() {
            return this.currentSessionInfo.getRequiredSession(this.request);
        }

        public Set<Role> getRoles() {
            return this.currentSessionInfo.getRoles(this.request);
        }

        public boolean hasRole(Role role) {
            return this.currentSessionInfo.hasRole(this.request, role);
        }

        public boolean hasRole(RoleEnum<?> role) {
            return this.currentSessionInfo.hasRole(this.request, role);
        }

        public boolean hasAnyRole(Collection<Role> targetRoles) {
            return this.currentSessionInfo.hasAnyRole(this.request, targetRoles);
        }

        public boolean hasAnyRoleEnum(Collection<RoleEnum<?>> targetRoles) {
            return this.currentSessionInfo.hasAnyRoleEnum(this.request, targetRoles);
        }
    }
}

