/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.session;

import io.datarouter.auth.exception.InvalidCredentialsException;
import io.datarouter.auth.model.dto.InterpretedSamlAssertion;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleManager;
import io.datarouter.auth.service.DatarouterUserCreationService;
import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.session.DatarouterSessionManager;
import io.datarouter.auth.session.Session;
import io.datarouter.auth.session.SessionBasedUser;
import io.datarouter.auth.session.UserSessionService;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserDao;
import io.datarouter.auth.storage.user.session.BaseDatarouterSessionDao;
import io.datarouter.auth.storage.user.session.DatarouterSession;
import io.datarouter.auth.storage.user.session.DatarouterSessionKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.types.MilliTime;
import io.datarouter.util.BooleanTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class DatarouterUserSessionService
implements UserSessionService {
    @Inject
    private DatarouterUserDao userDao;
    @Inject
    private BaseDatarouterSessionDao sessionDao;
    @Inject
    private DatarouterSessionManager sessionManager;
    @Inject
    private DatarouterUserCreationService userCreationService;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterUserHistoryService userHistoryService;

    @Override
    public void setSessionCookies(HttpServletResponse response, Session session) {
        this.sessionManager.addUserTokenCookie(response, session.getUserToken());
        this.sessionManager.addSessionTokenCookie(response, session.getSessionToken());
    }

    @Override
    public void clearSessionCookies(HttpServletResponse response) {
        this.sessionManager.clearUserTokenCookie(response);
        this.sessionManager.clearSessionTokenCookie(response);
    }

    @Override
    public Session signInUserFromSamlResponse(HttpServletRequest request, InterpretedSamlAssertion interpretedSamlAssertion) {
        DatarouterUser user = this.datarouterUserService.findUserByUsername(interpretedSamlAssertion.username(), true).orElseGet(() -> this.userCreationService.createAutomaticUser(interpretedSamlAssertion.username(), "SAML User"));
        if (BooleanTool.isFalseOrNull((Boolean)user.getEnabled())) {
            throw new InvalidCredentialsException("user not enabled (" + interpretedSamlAssertion.username() + ")");
        }
        user.setLastLoggedIn(MilliTime.now());
        DatarouterSession session = DatarouterSession.createFromUser(user);
        Optional<SamlChanges> changes = this.getSamlSignOnChanges(user, interpretedSamlAssertion);
        if (changes.isPresent()) {
            this.userHistoryService.recordSamlSignOnChanges(user, changes.get().changeString());
            user.setSamlGroups(new ArrayList<String>(interpretedSamlAssertion.roleGroupAttributes()));
            session.setRoles(changes.get().computedRoles());
        } else {
            session.setRoles(this.roleManager.calculateRolesWithGroups(user.getRolesIgnoreSaml(), user.getSamlGroups()));
        }
        this.userDao.put(user);
        this.sessionDao.put(session);
        return session;
    }

    @Override
    public SessionBasedUser createAuthorizedUser(String username, String description) {
        return this.userCreationService.createAutomaticUser(username, description);
    }

    @Override
    public void deleteSession(HttpServletRequest request) {
        Optional.ofNullable(this.sessionManager.getSessionTokenFromCookie(request)).map(DatarouterSessionKey::new).ifPresent(this.sessionDao::delete);
    }

    @Override
    public void deleteUserSessions(List<String> usernames) {
        HashSet<String> usernameSet = new HashSet<String>(usernames);
        this.sessionDao.scan().include(session -> usernameSet.contains(session.getUsername())).map(BaseDatabean::getKey).flush(this.sessionDao::deleteMulti);
    }

    @Override
    public Optional<ZoneId> getZoneId(String username) {
        return this.userDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username)).getZoneId();
    }

    public Optional<SamlChanges> getSamlSignOnChanges(DatarouterUser user, InterpretedSamlAssertion interpretedSamlAssertion) {
        if (interpretedSamlAssertion.roleGroupAttributes().equals(new HashSet<String>(user.getSamlGroups()))) {
            return Optional.empty();
        }
        SortedSet lostGroups = (SortedSet)Scanner.of(user.getSamlGroups()).exclude(interpretedSamlAssertion.roleGroupAttributes()::contains).collect(TreeSet::new);
        SortedSet gainedGroups = (SortedSet)Scanner.of(interpretedSamlAssertion.roleGroupAttributes()).exclude(user.getSamlGroups()::contains).exclude(Objects::isNull).collect(TreeSet::new);
        Set<Role> previouslyComputedRoles = this.roleManager.calculateRolesWithGroups(user.getRolesIgnoreSaml(), user.getSamlGroups());
        Set<Role> newComputedRoles = this.roleManager.calculateRolesWithGroups(user.getRolesIgnoreSaml(), interpretedSamlAssertion.roleGroupAttributes());
        String lostGroupsString = "";
        String lostRolesString = "";
        if (!lostGroups.isEmpty()) {
            lostGroupsString = "SAML groups lost: %s.".formatted(String.join((CharSequence)", ", lostGroups));
            SortedSet lostRoles = (SortedSet)Scanner.of(previouslyComputedRoles).exclude(newComputedRoles::contains).collect(TreeSet::new);
            lostRolesString = lostRoles.isEmpty() ? "No roles lost due to lost SAML groups." : "Net roles lost: %s.".formatted(String.join((CharSequence)", ", lostRoles.stream().map(Role::getPersistentString).toList()));
        }
        String gainedGroupsString = "";
        String gainedRolesString = "";
        if (!gainedGroups.isEmpty()) {
            gainedGroupsString = "SAML groups gained: %s.".formatted(String.join((CharSequence)", ", gainedGroups));
            SortedSet gainedRoles = (SortedSet)Scanner.of(newComputedRoles).exclude(previouslyComputedRoles::contains).collect(TreeSet::new);
            gainedRolesString = gainedRoles.isEmpty() ? "No roles provided by new SAML groups." : "Net roles gained: %s.".formatted(String.join((CharSequence)", ", gainedRoles.stream().map(Role::getPersistentString).toList()));
        }
        String changeString = String.join((CharSequence)"\n", Scanner.of((Object[])new String[]{"Changes detected from last SAML sign on.", gainedGroupsString, lostGroupsString, gainedRolesString, lostRolesString}).exclude(String::isEmpty).list());
        return Optional.of(new SamlChanges(newComputedRoles, changeString));
    }

    public record SamlChanges(Set<Role> computedRoles, String changeString) {
    }
}

