/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.session;

import io.datarouter.auth.config.DatarouterAuthenticationConfig;
import io.datarouter.auth.storage.user.session.DatarouterSession;
import io.datarouter.auth.util.CookieTool;
import io.datarouter.util.net.UrlTool;
import io.datarouter.util.string.StringTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class DatarouterSessionManager {
    private static final String DATAROUTER_SESSION_ATTRIBUTE = "datarouterSession";
    private static final int TARGET_URL_COOKIE_EXPIRATION_SECONDS = 1800;
    @Inject
    private DatarouterAuthenticationConfig config;

    public void addTargetUrlCookie(HttpServletResponse response, String targetUrl) {
        CookieTool.addCookie(response, this.config.getTargetUrlName(), UrlTool.encode((String)targetUrl), "/", 1800);
    }

    public URL getTargetUrlFromCookie(HttpServletRequest request) {
        String targetUrlString = CookieTool.getCookieValue(request, this.config.getTargetUrlName());
        if (StringTool.isEmpty((String)targetUrlString)) {
            return null;
        }
        targetUrlString = UrlTool.decode((String)targetUrlString);
        try {
            return new URL(targetUrlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid targetUrl:" + targetUrlString);
        }
    }

    public void clearTargetUrlCookie(HttpServletResponse response) {
        CookieTool.deleteCookie(response, this.config.getTargetUrlName());
    }

    public void addSessionTokenCookie(HttpServletResponse response, String sessionToken) {
        CookieTool.addCookie(response, this.config.getSessionTokenCookieName(), sessionToken, "/", this.config.getSessionTokenTimeoutDuration().getSeconds(), this.config.useSameSiteNone());
    }

    public String getSessionTokenFromCookie(HttpServletRequest request) {
        return CookieTool.getCookieValue(request, this.config.getSessionTokenCookieName());
    }

    public void clearSessionTokenCookie(HttpServletResponse response) {
        CookieTool.deleteCookie(response, this.config.getSessionTokenCookieName());
    }

    public void addUserTokenCookie(HttpServletResponse response, String userToken) {
        CookieTool.addCookie(response, this.config.getUserTokenCookieName(), userToken, "/", this.config.getUserTokenTimeoutDuration().getSeconds(), this.config.useSameSiteNone());
    }

    public String getUserTokenFromCookie(HttpServletRequest request) {
        return CookieTool.getCookieValue(request, this.config.getUserTokenCookieName());
    }

    public void clearUserTokenCookie(HttpServletResponse response) {
        CookieTool.deleteCookie(response, this.config.getUserTokenCookieName());
    }

    public static void addToRequest(ServletRequest request, DatarouterSession userSession) {
        request.setAttribute(DATAROUTER_SESSION_ATTRIBUTE, (Object)userSession);
    }

    public static Optional<DatarouterSession> getFromRequest(ServletRequest request) {
        DatarouterSession session = (DatarouterSession)request.getAttribute(DATAROUTER_SESSION_ATTRIBUTE);
        return Optional.ofNullable(session);
    }
}

