/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.model.dto.RoleApprovalRequirementStatus;
import io.datarouter.auth.model.dto.UserRoleMetadata;
import io.datarouter.auth.role.DatarouterUserRole;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleApprovalType;
import io.datarouter.auth.role.RoleManager;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.session.Session;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserDao;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserKey;
import io.datarouter.auth.storage.user.datarouteruser.cache.DatarouterUserByIdCache;
import io.datarouter.auth.storage.user.datarouteruser.cache.DatarouterUserByUserTokenCache;
import io.datarouter.auth.storage.user.datarouteruser.cache.DatarouterUserByUsernameCache;
import io.datarouter.auth.storage.user.roleapprovals.DatarouterUserRoleApprovalDao;
import io.datarouter.auth.storage.user.roleapprovals.DatarouterUserRoleApprovalKey;
import io.datarouter.auth.util.PasswordTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class DatarouterUserService
implements UserInfo {
    @Inject
    private DatarouterUserDao userDao;
    @Inject
    private DatarouterUserByUsernameCache datarouterUserByUsernameCache;
    @Inject
    private DatarouterUserByUserTokenCache datarouterUserByUserTokenCache;
    @Inject
    private DatarouterUserByIdCache datarouterUserByIdCache;
    @Inject
    private DatarouterUserRoleApprovalDao roleApprovalDao;
    @Inject
    private RoleManager roleManager;

    public Scanner<DatarouterUser> scanAllUsers(boolean enabledOnly, Set<Role> includedRoles) {
        if (includedRoles.isEmpty()) {
            return Scanner.empty();
        }
        return this.userDao.scan().include(user -> !enabledOnly || user.getEnabled() != false).include(user -> user.getRolesIgnoreSaml().stream().anyMatch(includedRoles::contains));
    }

    public Optional<DatarouterUser> findUserByUsername(String username, boolean allowCached) {
        if (StringTool.isEmptyOrWhitespace((String)username)) {
            return Optional.empty();
        }
        if (allowCached) {
            return this.datarouterUserByUsernameCache.get(username);
        }
        return Optional.ofNullable(this.userDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username)));
    }

    public DatarouterUser getUserByUsername(String username, boolean allowCached) {
        return this.findUserByUsername(username, allowCached).orElseThrow(() -> new RuntimeException("User not found for username=" + username));
    }

    public Optional<DatarouterUser> findUserByToken(String token, boolean allowCached) {
        if (StringTool.isEmptyOrWhitespace((String)token)) {
            return Optional.empty();
        }
        if (allowCached) {
            return this.datarouterUserByUserTokenCache.get(token);
        }
        return this.userDao.find(new DatarouterUser.DatarouterUserByUserTokenLookup(token));
    }

    public DatarouterUser getUserByToken(String token, boolean allowCached) {
        return this.findUserByToken(token, allowCached).orElseThrow(() -> new RuntimeException("User not found for userToken=" + token));
    }

    public Optional<DatarouterUser> findUserById(Long id, boolean allowCached) {
        if (id == null) {
            return Optional.empty();
        }
        if (allowCached) {
            return this.datarouterUserByIdCache.get(id);
        }
        return this.userDao.find(new DatarouterUserKey(id));
    }

    public DatarouterUser getUserById(Long id, boolean allowCached) {
        return this.findUserById(id, allowCached).orElseThrow(() -> new RuntimeException("User not found for id=" + String.valueOf(id)));
    }

    public Set<Role> getUserRolesWithSamlGroups(DatarouterUser user) {
        return this.getUserRolesWithSamlGroups(Optional.ofNullable(user));
    }

    public Set<Role> getUserRolesWithSamlGroups(Optional<DatarouterUser> optionalUser) {
        return optionalUser.map(user -> user.getRolesWithSamlGroups(this.roleManager)).map(HashSet::new).orElseGet(HashSet::new);
    }

    @Override
    public Set<Role> getRolesByUsername(String username, boolean allowCached) {
        return this.getUserRolesWithSamlGroups(this.findUserByUsername(username, allowCached));
    }

    public DatarouterUser getAndValidateCurrentUser(Session session) {
        DatarouterUser user = this.getUserBySession(session);
        if (user == null || !user.getEnabled().booleanValue()) {
            throw new RuntimeException("Current user does not exist or is not enabled.");
        }
        return user;
    }

    public DatarouterUser getUserBySession(Session session) {
        if (session == null || session.getUserId() == null) {
            return null;
        }
        return this.userDao.get(new DatarouterUserKey(session.getUserId()));
    }

    public boolean canEditUserPassword(DatarouterUser editor, DatarouterUser user) {
        return user.equals(editor) || !this.isDatarouterAdmin(user) && this.isDatarouterAdmin(editor) && editor.getEnabled() != false;
    }

    public boolean canEditUser(DatarouterUser editor, DatarouterUser user) {
        return user.equals(editor) || this.isDatarouterAdmin(editor) && editor.getEnabled() != false;
    }

    public boolean canHavePassword(DatarouterUser user) {
        return user.getPasswordDigest() != null || this.isDatarouterAdmin(user);
    }

    public boolean isPasswordCorrect(DatarouterUser user, String rawPassword) {
        if (user == null || rawPassword == null) {
            return false;
        }
        String passwordDigest = PasswordTool.digest(user.getPasswordSalt(), rawPassword);
        return Objects.equals(user.getPasswordDigest(), passwordDigest);
    }

    public void assertUserDoesNotExist(Long id, String userToken, String username) {
        Require.isEmpty(this.findUserById(id, false), (String)("DatarouterUser already exists with id=" + String.valueOf(id)));
        Require.isEmpty(this.findUserByToken(userToken, false), (String)("DatarouterUser already exists with userToken=" + userToken));
        Require.isEmpty(this.findUserByUsername(username, false), (String)("DatarouterUser already exists with username=" + username));
    }

    public boolean isDatarouterAdmin(DatarouterUser user) {
        return this.getUserRolesWithSamlGroups(user).contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole());
    }

    public Map<Role, Map<RoleApprovalType, Set<String>>> getCurrentRoleApprovals(DatarouterUser user) {
        return (Map)Scanner.of(this.roleApprovalDao.getAllOutstandingApprovalsForUser(user)).exclude(roleApproval -> this.roleManager.findRoleFromPersistentString(((DatarouterUserRoleApprovalKey)roleApproval.getKey()).getRequestedRole()).isEmpty()).exclude(roleApproval -> this.roleManager.findRoleApprovalTypeFromPersistentString(roleApproval.getApprovalType()).isEmpty()).collect(Collectors.groupingBy(roleApproval -> this.roleManager.findRoleFromPersistentString(((DatarouterUserRoleApprovalKey)roleApproval.getKey()).getRequestedRole()).get(), Collectors.groupingBy(roleApproval -> this.roleManager.findRoleApprovalTypeFromPersistentString(roleApproval.getApprovalType()).get(), Collectors.mapping(roleApproval -> ((DatarouterUserRoleApprovalKey)roleApproval.getKey()).getApproverUsername(), Collectors.toSet()))));
    }

    public List<UserRoleMetadata> getRoleMetadataForUser(DatarouterUser editor, DatarouterUser user) {
        HashSet<Role> currentRoles = new HashSet<Role>(user.getRolesIgnoreSaml());
        Set<Role> availableRoles = this.roleManager.getAllRoles();
        Map<Role, Map<RoleApprovalType, Integer>> roleApprovalRequirements = this.roleManager.getAllRoleApprovalRequirements();
        Map<Role, Map<RoleApprovalType, Set<String>>> currentRoleApprovals = this.getCurrentRoleApprovals(user);
        HashSet<RoleApprovalType> relevantApprovalTypes = new HashSet<RoleApprovalType>();
        Scanner.of(roleApprovalRequirements.values()).map(Map::keySet).forEach(relevantApprovalTypes::addAll);
        List<RoleApprovalType> prioritizedApprovalTypes = this.roleManager.getPrioritizedRoleApprovalTypes(editor, user, relevantApprovalTypes);
        Map<Role, List<String>> groupsHasByRole = this.roleManager.getGroupsByRole(user.getSamlGroups());
        return Scanner.of(availableRoles).map(availableRole -> {
            Map requirementsOfRole = roleApprovalRequirements.getOrDefault(availableRole, new HashMap());
            Map currentApprovalsForRole = currentRoleApprovals.getOrDefault(availableRole, new HashMap());
            Map requirementStatusByApprovalType = Scanner.of(requirementsOfRole.keySet()).toMap(Function.identity(), roleApprovalType -> new RoleApprovalRequirementStatus((Integer)requirementsOfRole.get(roleApprovalType), currentApprovalsForRole.getOrDefault(roleApprovalType, new HashSet())));
            boolean rolePrivilegesGranted = currentRoles.contains(availableRole);
            Optional<Object> currentEditorPreviouslyApprovedType = Optional.empty();
            for (RoleApprovalType approvalType2 : currentApprovalsForRole.keySet()) {
                if (!((Set)currentApprovalsForRole.get(approvalType2)).contains(editor.getUsername())) continue;
                if (!requirementStatusByApprovalType.containsKey(approvalType2)) {
                    this.roleApprovalDao.deleteOutstandingApprovalsOfApprovalTypeForRole(availableRole.persistentString, approvalType2.persistentString());
                    continue;
                }
                currentEditorPreviouslyApprovedType = Optional.of(approvalType2);
            }
            Optional<Object> prioritizedApprovalType = !rolePrivilegesGranted ? (currentEditorPreviouslyApprovedType.isPresent() ? currentEditorPreviouslyApprovedType : prioritizedApprovalTypes.stream().filter(approvalType -> requirementStatusByApprovalType.containsKey(approvalType) && ((RoleApprovalRequirementStatus)requirementStatusByApprovalType.get(approvalType)).currentApprovers().size() < ((RoleApprovalRequirementStatus)requirementStatusByApprovalType.get(approvalType)).requiredApprovals()).findFirst()) : prioritizedApprovalTypes.stream().filter(requirementStatusByApprovalType::containsKey).findFirst();
            boolean canRevoke = !DatarouterUserRole.DATAROUTER_ADMIN.getPersistentString().equals(availableRole.getPersistentString()) && this.isDatarouterAdmin(editor) || user.equals(editor);
            return new UserRoleMetadata((Role)availableRole, currentRoles.contains(availableRole), requirementStatusByApprovalType, (Optional<RoleApprovalType>)prioritizedApprovalType, Optional.of(canRevoke), (List)groupsHasByRole.get(availableRole));
        }).list();
    }
}

