/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.model.dto.HistoryChange;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserDao;
import io.datarouter.auth.storage.user.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.user.permissionrequest.PermissionRequest;
import io.datarouter.auth.storage.user.userhistory.DatarouterUserHistoryDao;
import io.datarouter.auth.storage.user.userhistory.DatarouterUserHistoryLog;
import io.datarouter.auth.storage.user.userhistory.DatarouterUserHistoryLogKey;
import io.datarouter.email.email.DatarouterHtmlEmailService;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.type.DatarouterEmailTypes;
import io.datarouter.email.type.SimpleEmailType;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.types.MilliTime;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.PTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Singleton
public class DatarouterUserHistoryService {
    public static final String CHANGELOG_TYPE = "DatarouterUserHistory";
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private DatarouterUserDao baseDatarouterUserDao;
    @Inject
    private DatarouterUserHistoryDao baseDatarouterUserHistoryDao;
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterEmailTypes.PermissionRequestEmailType permissionRequestEmailType;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private ServiceName serviceName;
    @Inject
    private EnvironmentName environmentName;

    public Map<PermissionRequest, Optional<HistoryChange>> getResolvedRequestToHistoryChangesMap(List<PermissionRequest> requests) {
        Map historyMap = Scanner.of(requests).map(PermissionRequest::toUserHistoryKey).map(key -> key.orElse(null)).include(Objects::nonNull).batch(100).map(this.baseDatarouterUserHistoryDao::getMulti).concat(Scanner::of).toMap(BaseDatabean::getKey, history -> new HistoryChange(history.getChanges(), this.datarouterUserService.findUserById(history.getEditor(), false)));
        return Scanner.of(requests).deduplicateConsecutive().toMap(Function.identity(), request -> request.toUserHistoryKey().map(historyKey -> historyMap.getOrDefault(historyKey, new HistoryChange(permissionRequest.getResolution().persistentString, Optional.empty()))));
    }

    public void putAndRecordCreate(DatarouterUser user, Long editorId, String editorUsername, String description) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistoryLog(user.getId(), user.getCreated(), editorId, DatarouterUserHistoryLog.DatarouterUserChangeType.CREATE, description));
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistoryLog.DatarouterUserChangeType.CREATE.persistentString, editorUsername).withComment(description).build();
        this.changelogRecorder.record(dto);
    }

    public void putAndRecordPasswordChange(DatarouterUser user, DatarouterUser editor, String signinUrl) {
        DatarouterUserHistoryLog history = new DatarouterUserHistoryLog(user.getId(), MilliTime.now(), editor.getId(), DatarouterUserHistoryLog.DatarouterUserChangeType.RESET, "password");
        this.doPutAndRecordEdit(user, history, false);
        this.sendPasswordChangeEmail(user, history, signinUrl);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistoryLog.DatarouterUserChangeType.RESET.persistentString, editor.getUsername()).build();
        this.changelogRecorder.record(dto);
    }

    public void putAndRecordTimezoneUpdate(DatarouterUser user, DatarouterUser editor, String changes, String signinUrl) {
        DatarouterUserHistoryLog history = new DatarouterUserHistoryLog(user.getId(), MilliTime.now(), editor.getId(), DatarouterUserHistoryLog.DatarouterUserChangeType.EDIT, changes);
        this.doPutAndRecordEdit(user, history, false);
        this.sendTimezoneUpdateEmail(user, history, signinUrl);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistoryLog.DatarouterUserChangeType.EDIT.persistentString, editor.getUsername()).withComment(changes).build();
        this.changelogRecorder.record(dto);
    }

    public void putAndRecordPermissionChange(DatarouterUser user, DatarouterUser editor, String changes, String signinUrl) {
        DatarouterUserHistoryLog history = new DatarouterUserHistoryLog(user.getId(), MilliTime.now(), editor.getId(), DatarouterUserHistoryLog.DatarouterUserChangeType.EDIT, changes);
        this.doPutAndRecordEdit(user, history, true);
        this.sendPermissionChangeEmail(user, history, signinUrl);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistoryLog.DatarouterUserChangeType.EDIT.persistentString, editor.getUsername()).withComment(changes).build();
        this.changelogRecorder.record(dto);
    }

    public void recordPermissionRequestDecline(DatarouterUser user, DatarouterUser editor, String changes, MilliTime declineTime) {
        DatarouterUserHistoryLog history = new DatarouterUserHistoryLog(user.getId(), declineTime, editor.getId(), DatarouterUserHistoryLog.DatarouterUserChangeType.INFO, changes);
        this.baseDatarouterUserHistoryDao.put(history);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistoryLog.DatarouterUserChangeType.INFO.persistentString, editor.getUsername()).withComment(changes).build();
        this.changelogRecorder.record(dto);
    }

    public void recordSamlSignOnChanges(DatarouterUser user, String changes) {
        DatarouterUserHistoryLog history = new DatarouterUserHistoryLog(user.getId(), MilliTime.now(), 1L, DatarouterUserHistoryLog.DatarouterUserChangeType.EDIT, changes);
        this.baseDatarouterUserHistoryDao.put(history);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistoryLog.DatarouterUserChangeType.SAML.persistentString, this.adminEmail.get()).withComment(changes).build();
        this.changelogRecorder.record(dto);
    }

    public void recordMessage(DatarouterUser user, DatarouterUser editor, String message) {
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistoryLog(user.getId(), MilliTime.now(), editor.getId(), DatarouterUserHistoryLog.DatarouterUserChangeType.INFO, message));
    }

    public void recordDeprovisions(List<DatarouterUser> users, Optional<DatarouterUser> editor) {
        MilliTime time = MilliTime.now();
        Long editorId = editor.map(DatarouterUser::getId).orElse(1L);
        Map histories = Scanner.of(users).map(user -> new DatarouterUserHistoryLog(user.getId(), time, editorId, DatarouterUserHistoryLog.DatarouterUserChangeType.DEPROVISION, "deprovisioned")).flush(this.baseDatarouterUserHistoryDao::putMulti).toMap(history -> ((DatarouterUserHistoryLogKey)history.getKey()).getUserId());
        ((Scanner)Scanner.of(users).map(DatarouterUser::getId).listTo(this.permissionRequestDao::scanOpenPermissionRequestsForUsers)).map(request -> request.decline(time.toInstant())).flush(this.permissionRequestDao::putMulti);
        editor.ifPresent(editorUser -> users.forEach(user -> this.sendDeprovisioningEmail((DatarouterUser)user, (DatarouterUserHistoryLog)((Object)((Object)((Object)histories.get(user.getId())))), (DatarouterUser)editorUser)));
        this.recordProvisioningChangelogs(users, editor, DatarouterUserHistoryLog.DatarouterUserChangeType.DEPROVISION);
    }

    public void recordRestores(List<DatarouterUser> users, Optional<DatarouterUser> editor) {
        MilliTime time = MilliTime.now();
        Long editorId = editor.map(DatarouterUser::getId).orElse(null);
        Scanner.of(users).map(user -> new DatarouterUserHistoryLog(user.getId(), time, editorId, DatarouterUserHistoryLog.DatarouterUserChangeType.RESTORE, "restored")).flush(this.baseDatarouterUserHistoryDao::putMulti);
        this.recordProvisioningChangelogs(users, editor, DatarouterUserHistoryLog.DatarouterUserChangeType.RESTORE);
    }

    public List<DatarouterUserHistoryLog> getHistoryForUser(Long userId) {
        return this.baseDatarouterUserHistoryDao.scanWithPrefix(new DatarouterUserHistoryLogKey(userId, null)).list();
    }

    public String getPermissionRequestEmailSubject(DatarouterUser user) {
        return this.getEmailSubject("Permission Request", user);
    }

    private void recordProvisioningChangelogs(List<DatarouterUser> users, Optional<DatarouterUser> editor, DatarouterUserHistoryLog.DatarouterUserChangeType action) {
        Scanner.of(users).map(DatarouterUser::getUsername).map(username -> new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, username, datarouterUserChangeType.persistentString, editor.map(DatarouterUser::getUsername).orElse(this.adminEmail.get()))).map(ChangelogRecorder.DatarouterChangelogDtoBuilder::build).forEach(arg_0 -> ((ChangelogRecorder)this.changelogRecorder).record(arg_0));
    }

    private void doPutAndRecordEdit(DatarouterUser user, DatarouterUserHistoryLog history, boolean permissionsChanged) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(history);
        if (permissionsChanged) {
            this.permissionRequestDao.scanOpenPermissionRequestsForUser(((DatarouterUserHistoryLogKey)history.getKey()).getUserId()).map(history::resolvePermissionRequest).flush(this.permissionRequestDao::putMulti);
        }
    }

    private void sendPasswordChangeEmail(DatarouterUser user, DatarouterUserHistoryLog history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor(), false);
        PTag p1 = TagCreator.p((String)String.format("Your user (%s) password has been changed by user %s (%s).", user.getUsername(), editor.getId(), editor.getUsername()));
        PTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.getPasswordChangedEmailSubject(user)).withTitle("Password Changed").withTitleHref(signInUrl).withContent((DomContent)content).from(user.getUsername()).to(user.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendTimezoneUpdateEmail(DatarouterUser user, DatarouterUserHistoryLog history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor(), false);
        PTag p1 = TagCreator.p((String)String.format("Your user (%s) timezone has been updated by %s", user.getUsername(), editor.getUsername()));
        PTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.getTimezoneChangedEmailSubject(user)).withTitle("Timezone Changed").withTitleHref(signInUrl).withContent((DomContent)content).from(user.getUsername()).to(user.getUsername()).to(editor.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendPermissionChangeEmail(DatarouterUser user, DatarouterUserHistoryLog history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor(), false);
        PTag p1 = TagCreator.p((String)String.format("%s permissions have been edited by %s", user.getUsername(), editor.getUsername()));
        PTag p2 = (PTag)TagCreator.p((String)("Changes: " + history.getChanges())).withStyle("white-space: pre-wrap");
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withTitleHref(signInUrl).withContent((DomContent)content).from(user.getUsername()).to(user.getUsername()).to(editor.getUsername()).to((SimpleEmailType)this.permissionRequestEmailType, this.serverTypeDetector.mightBeProduction()).toSubscribers(this.serverTypeDetector.mightBeProduction()).toAdmin(this.serverTypeDetector.mightBeDevelopment());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    public void sendDeprovisioningEmail(DatarouterUser user, DatarouterUserHistoryLog history, DatarouterUser editor) {
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)String.format("Your user (%s) has been %s by user %s (%s).", user.getUsername(), history.getChanges(), editor.getId(), editor.getUsername()))});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withContent((DomContent)content).from(user.getUsername()).to(user.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private String getPasswordChangedEmailSubject(DatarouterUser user) {
        return this.getEmailSubject("Password Changed", user);
    }

    private String getTimezoneChangedEmailSubject(DatarouterUser user) {
        return this.getEmailSubject("Timezone Changed", user);
    }

    private String getEmailSubject(String prefix, DatarouterUser user) {
        return String.format("%s %s - %s - %s", prefix, user.getUsername(), this.environmentName.get(), this.serviceName.get());
    }

    private static PTag makeSignInParagraph(String signInUrl) {
        return TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"Please sign in again to refresh your session: "), TagCreator.a((String)"sign in").withHref(signInUrl)});
    }
}

