/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.authenticate.DatarouterTokenGenerator;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleManager;
import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserKey;
import io.datarouter.auth.util.PasswordTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.types.MilliTime;
import io.datarouter.util.number.RandomTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserCreationService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserCreationService.class);
    public static final long ADMIN_ID = 1L;
    public static final String SAML_USER_CREATION_DESCRIPTION = "SAML User";
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterUserHistoryService userHistoryService;
    @Inject
    private RoleManager roleManager;

    public void createFirstAdminUser(String defaultPassword) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.ADMIN, defaultPassword, Optional.of(ZoneId.systemDefault()));
        this.populateManualFields(user, this.adminEmail.get(), this.roleManager.getSuperAdminRoles(), true);
        this.finishCreate(user, 1L, this.adminEmail.get(), "Automatically created admin user.");
        logger.warn("Created default admin user account");
    }

    public DatarouterUser createAutomaticUser(String username, String description) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.AUTO, null, Optional.empty());
        this.populateManualFields(user, username, this.roleManager.getDefaultRoles(), true);
        return this.finishCreate(user, 1L, this.adminEmail.get(), description);
    }

    public DatarouterUser createManualUser(DatarouterUser creator, String username, String password, Set<Role> requestedRoles, boolean enabled, Optional<ZoneId> zoneId, Optional<String> description) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.MANUAL, password, zoneId);
        requestedRoles = (Set)Scanner.of(requestedRoles).append(this.roleManager.getDefaultRoles()).collect(HashSet::new);
        this.populateManualFields(user, username, requestedRoles, enabled);
        String roleChangeString = user.getRolesIgnoreSaml().isEmpty() ? "" : ": roles: " + String.valueOf(List.of()) + " => " + String.valueOf(user.getRolesIgnoreSaml());
        String historyDescription = description.orElse("User manually created by " + creator.getUsername()) + roleChangeString;
        return this.finishCreate(user, creator.getId(), creator.getUsername(), historyDescription);
    }

    private void populateGeneratedFields(DatarouterUser user, CreateType type, String password, Optional<ZoneId> zoneId) {
        ((DatarouterUserKey)user.getKey()).setId(type == CreateType.ADMIN ? 1L : RandomTool.nextPositiveLong());
        user.setUserToken(DatarouterTokenGenerator.generateRandomToken());
        user.setCreated(MilliTime.now());
        user.setLastLoggedIn(type == CreateType.ADMIN ? user.getCreated() : null);
        user.setPasswordSalt(type == CreateType.AUTO ? null : PasswordTool.generateSalt());
        String digest = type == CreateType.AUTO || password == null ? null : PasswordTool.digest(user.getPasswordSalt(), password);
        user.setPasswordDigest(digest);
        user.setZoneId(zoneId.orElse(ZoneId.systemDefault()));
    }

    private void populateManualFields(DatarouterUser user, String username, Set<Role> roles, Boolean enabled) {
        user.setUsername(username);
        user.setRoles(roles);
        user.setEnabled(enabled);
    }

    private DatarouterUser finishCreate(DatarouterUser user, Long editorId, String editorUsername, String description) {
        this.datarouterUserService.assertUserDoesNotExist(user.getId(), user.getUserToken(), user.getUsername());
        this.userHistoryService.putAndRecordCreate(user, editorId, editorUsername, description);
        return user;
    }

    private static enum CreateType {
        ADMIN,
        AUTO,
        MANUAL;

    }
}

